/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.CommonBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.SaveProjectAsTemplateDialog;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveProjectAsTemplateAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(SaveProjectAsTemplateAction.class);
    private static final String PROJECT_TEMPLATE_XML = "project-template.xml";
    static final String FILE_HEADER_TEMPLATE_PLACEHOLDER = "<IntelliJ_File_Header>";

    public void actionPerformed(AnActionEvent e) {
        final Project project2 = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        assert (project2 != null);
        if (!ProjectUtil.isDirectoryBased(project2)) {
            Messages.showErrorDialog((Project)project2, (String)"Project templates do not support old .ipr (file-based) format.\nPlease convert your project via File->Save as Directory-Based format.", (String)CommonBundle.getErrorTitle());
            return;
        }
        VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project2, ".idea/description.html");
        final SaveProjectAsTemplateDialog dialog = new SaveProjectAsTemplateDialog(project2, descriptionFile);
        if (dialog.showAndGet()) {
            final Module moduleToSave = dialog.getModuleToSave();
            final File file2 = dialog.getTemplateFile();
            final String description = dialog.getDescription();
            FileDocumentManager.getInstance().saveAllDocuments();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Saving Project as Template", true, PerformInBackgroundOption.DEAF){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/platform/templates/SaveProjectAsTemplateAction$1", "run"));
                    }
                    SaveProjectAsTemplateAction.saveProject(project2, file2, moduleToSave, description, dialog.isReplaceParameters(), indicator, SaveProjectAsTemplateAction.shouldEscape());
                }

                public void onSuccess() {
                    Messages.showInfoMessage((String)(FileUtil.getNameWithoutExtension((File)file2) + " was successfully created.\n" + "It's available now in Project Wizard"), (String)"Template Created");
                }

                public void onCancel() {
                    file2.delete();
                }
            });
        }
    }

    public static VirtualFile getDescriptionFile(Project project2, String path) {
        VirtualFile baseDir = project2.getBaseDir();
        return baseDir != null ? baseDir.findFileByRelativePath(path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProject(final Project project2, File zipFile, Module moduleToSave, String description, boolean replaceParameters, final ProgressIndicator indicator, final boolean shouldEscape) {
        final Map<String, String> parameters = SaveProjectAsTemplateAction.computeParameters(project2, replaceParameters);
        indicator.setText("Saving project...");
        ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> ((Project)project2).save()), indicator.getModalityState());
        indicator.setText("Processing project files...");
        ZipOutputStream stream = null;
        try {
            FileUtil.ensureExists((File)zipFile.getParentFile());
            stream = new ZipOutputStream(new FileOutputStream(zipFile));
            final VirtualFile dir = SaveProjectAsTemplateAction.getDirectoryToSave(project2, moduleToSave);
            SaveProjectAsTemplateAction.writeFile(".idea/description.html", description, project2, dir, stream, true, indicator);
            if (replaceParameters) {
                String text = SaveProjectAsTemplateAction.getInputFieldsText(parameters);
                SaveProjectAsTemplateAction.writeFile(".idea/project-template.xml", text, project2, dir, stream, false, indicator);
            }
            String metaDescription = SaveProjectAsTemplateAction.getTemplateMetaText(shouldEscape);
            SaveProjectAsTemplateAction.writeFile(".idea/template-meta.xml", metaDescription, project2, dir, stream, true, indicator);
            ProjectFileIndex index = moduleToSave == null ? ProjectRootManager.getInstance((Project)project2).getFileIndex() : ModuleRootManager.getInstance((Module)moduleToSave).getFileIndex();
            final ZipOutputStream finalStream = stream;
            index.iterateContent(new ContentIterator(){

                public boolean processFile(final VirtualFile virtualFile) {
                    if (!virtualFile.isDirectory()) {
                        String fileName = virtualFile.getName();
                        indicator.setText2(fileName);
                        try {
                            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)dir, (char)'/');
                            if (relativePath == null) {
                                throw new RuntimeException("Can't find relative path for " + virtualFile + " in " + dir);
                            }
                            boolean system = ".idea".equals(virtualFile.getParent().getName());
                            if (!(!system || fileName.equals("description.html") || fileName.equals(SaveProjectAsTemplateAction.PROJECT_TEMPLATE_XML) || fileName.equals("template-meta.xml") || fileName.equals("misc.xml") || fileName.equals("modules.xml") || fileName.equals("workspace.xml") || fileName.endsWith(".iml"))) {
                                return true;
                            }
                            ZipUtil.addFileToZip((ZipOutputStream)finalStream, (File)new File(virtualFile.getPath()), (String)(dir.getName() + "/" + relativePath), null, null, (ZipUtil.FileContentProcessor)new ZipUtil.FileContentProcessor(){

                                public InputStream getContent(File file2) throws IOException {
                                    if (virtualFile.getFileType().isBinary() || SaveProjectAsTemplateAction.PROJECT_TEMPLATE_XML.equals(virtualFile.getName())) {
                                        return STANDARD.getContent(file2);
                                    }
                                    String result2 = SaveProjectAsTemplateAction.getEncodedContent(virtualFile, project2, parameters, SaveProjectAsTemplateAction.getFileHeaderTemplateName(), shouldEscape);
                                    return new ByteArrayInputStream(result2.getBytes(CharsetToolkit.UTF8_CHARSET));
                                }
                            });
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    indicator.checkCanceled();
                    return true;
                }
            });
        }
        catch (Exception ex) {
            try {
                LOG.error((Throwable)ex);
                UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project2, (String)"Can't save project as template", (String)"Internal Error"));
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(stream);
                throw throwable;
            }
            StreamUtil.closeStream((Closeable)stream);
        }
        StreamUtil.closeStream((Closeable)stream);
    }

    static String getFileHeaderTemplateName() {
        if (PlatformUtils.isIntelliJ()) {
            return FileTemplateBase.getQualifiedName("File Header", "java");
        }
        if (PlatformUtils.isPhpStorm()) {
            return FileTemplateBase.getQualifiedName("PHP File Header", "php");
        }
        throw new IllegalStateException("Provide file header template for your IDE");
    }

    private static void writeFile(String path, String text, Project project2, VirtualFile dir, ZipOutputStream stream, boolean overwrite, ProgressIndicator indicator) throws IOException {
        VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project2, path);
        if (descriptionFile == null) {
            stream.putNextEntry(new ZipEntry(dir.getName() + "/" + path));
            stream.write(text.getBytes());
            stream.closeEntry();
        } else if (overwrite) {
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
                try {
                    VfsUtil.saveText((VirtualFile)descriptionFile, (String)text);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }), indicator.getModalityState());
        }
    }

    public static Map<String, String> computeParameters(Project project2, boolean replaceParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (replaceParameters) {
            ApplicationManager.getApplication().runReadAction(() -> {
                ProjectTemplateParameterFactory[] extensions;
                for (ProjectTemplateParameterFactory extension : extensions = (ProjectTemplateParameterFactory[])Extensions.getExtensions((ExtensionPointName)ProjectTemplateParameterFactory.EP_NAME)) {
                    String value = extension.detectParameterValue(project2);
                    if (value == null) continue;
                    parameters.put(value, extension.getParameterId());
                }
            });
        }
        return parameters;
    }

    public static String getEncodedContent(VirtualFile virtualFile, Project project2, Map<String, String> parameters) throws IOException {
        return SaveProjectAsTemplateAction.getEncodedContent(virtualFile, project2, parameters, FileTemplateBase.getQualifiedName("File Header", "java"), true);
    }

    private static String getEncodedContent(VirtualFile virtualFile, Project project2, Map<String, String> parameters, String fileHeaderTemplateName, boolean shouldEscape) throws IOException {
        String text = VfsUtilCore.loadText((VirtualFile)virtualFile);
        FileTemplate template = FileTemplateManager.getInstance(project2).getDefaultTemplate(fileHeaderTemplateName);
        String templateText = template.getText();
        Pattern pattern = FileTemplateUtil.getTemplatePattern(template, project2, (TIntObjectHashMap<String>)new TIntObjectHashMap());
        String result2 = SaveProjectAsTemplateAction.convertTemplates(text, pattern, templateText, shouldEscape);
        result2 = ProjectTemplateFileProcessor.encodeFile(result2, virtualFile, project2);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            result2 = result2.replace(entry.getKey(), "${" + entry.getValue() + "}");
        }
        return result2;
    }

    private static VirtualFile getDirectoryToSave(Project project2, @Nullable Module module2) {
        if (module2 == null) {
            return project2.getBaseDir();
        }
        VirtualFile moduleFile = module2.getModuleFile();
        assert (moduleFile != null);
        return moduleFile.getParent();
    }

    public static String convertTemplates(String input, Pattern pattern, String template, boolean shouldEscape) {
        int start;
        Matcher matcher = pattern.matcher(input);
        int n = start = matcher.matches() ? matcher.start(1) : -1;
        if (!shouldEscape) {
            if (start == -1) {
                return input;
            }
            return input.substring(0, start) + FILE_HEADER_TEMPLATE_PLACEHOLDER + input.substring(matcher.end(1));
        }
        StringBuilder builder = new StringBuilder(input.length() + 10);
        for (int i = 0; i < input.length(); ++i) {
            char c;
            if (start == i) {
                builder.append(template);
                i = matcher.end(1);
            }
            if ((c = input.charAt(i)) == '$' || c == '#') {
                builder.append('\\');
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static String getInputFieldsText(Map<String, String> parameters) {
        Element element = new Element("template");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            Element field = new Element("input-field");
            field.setText(entry.getValue());
            field.setAttribute("default", entry.getKey());
            element.addContent(field);
        }
        return JDOMUtil.writeElement((Element)element);
    }

    private static String getTemplateMetaText(boolean shouldEncode) {
        Element element = new Element("template");
        element.setAttribute("unencoded", String.valueOf(!shouldEncode));
        return JDOMUtil.writeElement((Element)element);
    }

    private static boolean shouldEscape() {
        return !PlatformUtils.isPhpStorm();
    }

    public void update(AnActionEvent e) {
        Project project2 = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabled(project2 != null && !project2.isDefault());
    }
}

