/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjuster;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetectorImpl;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetectAndAdjustIndentOptionsTask
extends ReadTask {
    private static final Logger LOG = Logger.getInstance(DetectAndAdjustIndentOptionsTask.class);
    private final Document myDocument;
    private final Project myProject;
    private final CommonCodeStyleSettings.IndentOptions myOptionsToAdjust;
    private final ExecutorService myExecutor;
    private volatile long myComputationStarted;

    public DetectAndAdjustIndentOptionsTask(@NotNull Project project2, @NotNull Document document2, @NotNull CommonCodeStyleSettings.IndentOptions toAdjust, @NotNull ExecutorService executor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask", "<init>"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask", "<init>"));
        }
        if (toAdjust == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAdjust", "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask", "<init>"));
        }
        this.myComputationStarted = 0L;
        this.myProject = project2;
        this.myDocument = document2;
        this.myOptionsToAdjust = toAdjust;
        this.myExecutor = executor;
    }

    private PsiFile getFile() {
        if (this.myProject.isDisposed()) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
    }

    @Override
    @Nullable
    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask", "performInReadAction"));
        }
        PsiFile file2 = this.getFile();
        if (file2 == null) {
            return null;
        }
        if (!PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(this.myDocument)) {
            this.scheduleInBackgroundForCommittedDocument();
            return null;
        }
        IndentOptionsDetectorImpl detector = new IndentOptionsDetectorImpl(file2, indicator);
        this.myComputationStarted = System.currentTimeMillis();
        IndentOptionsAdjuster adjuster = detector.getIndentOptionsAdjuster();
        return new ReadTask.Continuation(adjuster != null ? () -> this.adjustOptions(adjuster) : EmptyRunnable.INSTANCE);
    }

    private void adjustOptions(IndentOptionsAdjuster adjuster) {
        long stamp = this.myDocument.getModificationStamp();
        adjuster.adjust(this.myOptionsToAdjust);
        if (this.myOptionsToAdjust instanceof TimeStampedIndentOptions) {
            ((TimeStampedIndentOptions)this.myOptionsToAdjust).setTimeStamp(stamp);
        }
    }

    @Override
    public void onCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask", "onCanceled"));
        }
        if (this.isComputingForTooLong()) {
            this.logTooLongComputation();
            return;
        }
        this.scheduleInBackgroundForCommittedDocument();
    }

    private void logTooLongComputation() {
        PsiFile file2 = this.getFile();
        String fileName = file2 != null ? file2.getName() : "";
        LOG.warn("Indent detection is too long for: " + fileName);
    }

    private boolean isComputingForTooLong() {
        return System.currentTimeMillis() - this.myComputationStarted > 5000L;
    }

    public void scheduleInBackgroundForCommittedDocument() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ReadTask.Continuation continuation = this.performInReadAction((ProgressIndicator)new DumbProgressIndicator());
            if (continuation != null) {
                continuation.getAction().run();
            }
        } else {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
            manager.performForCommittedDocument(this.myDocument, () -> ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myExecutor, (ReadTask)this));
        }
    }
}

