/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SPIReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SPIReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        block10: {
            String[] filenames;
            SearchScope scope;
            PsiElement element;
            block9: {
                PsiFile[] files;
                if (p == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/SPIReferencesSearcher", "processQuery"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/SPIReferencesSearcher", "processQuery"));
                }
                element = p.getElementToSearch();
                if (!element.isValid()) {
                    return;
                }
                scope = p.getEffectiveSearchScope();
                if (!(scope instanceof GlobalSearchScope)) {
                    return;
                }
                if (!(element instanceof PsiClass)) break block9;
                PsiClass aClass = (PsiClass)element;
                String jvmClassName = ClassUtil.getJVMClassName((PsiClass)aClass);
                if (jvmClassName == null) {
                    return;
                }
                for (PsiFile file2 : files = FilenameIndex.getFilesByName(aClass.getProject(), jvmClassName, (GlobalSearchScope)scope)) {
                    PsiReference reference;
                    if (file2.getLanguage() != SPILanguage.INSTANCE || (reference = file2.getReference()) == null) continue;
                    consumer.process((Object)reference);
                }
                break block10;
            }
            if (!(element instanceof PsiPackage)) break block10;
            String qualifiedName = ((PsiPackage)element).getQualifiedName();
            Project project2 = element.getProject();
            for (String filename : filenames = FilenameIndex.getAllFilenames(project2)) {
                PsiFile[] files;
                if (!filename.startsWith(qualifiedName + ".")) continue;
                for (PsiFile file3 : files = FilenameIndex.getFilesByName(project2, filename, (GlobalSearchScope)scope)) {
                    PsiReference[] references;
                    if (file3.getLanguage() != SPILanguage.INSTANCE) continue;
                    for (PsiReference reference : references = file3.getReferences()) {
                        if (!reference.getCanonicalText().equals(qualifiedName)) continue;
                        consumer.process((Object)reference);
                    }
                }
            }
        }
    }
}

