/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.LazyParseableElement");
    private static final StaticGetter<CharSequence> NO_TEXT = new StaticGetter(null);
    private final ChameleonLock lock;
    @NotNull
    private Getter<CharSequence> myText;
    private boolean myParsed;
    private static boolean ourParsingAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyParseableElement(@NotNull IElementType type, @Nullable CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LazyParseableElement", "<init>"));
        }
        super(type);
        ChameleonLock chameleonLock = this.lock = new ChameleonLock();
        synchronized (chameleonLock) {
            boolean bl = this.myParsed = text == null;
            if (text == null) {
                this.myText = NO_TEXT;
            } else {
                this.myText = new StaticGetter((Object)ImmutableCharSequence.asImmutable((CharSequence)text));
                this.setCachedLength(text.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                this.myText = NO_TEXT;
            } else {
                this.setCachedLength(((CharSequence)this.myText.get()).length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getText() {
        CharSequence text = this.myText();
        if (text != null) {
            String string = text.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LazyParseableElement", "getText"));
            }
            return string;
        }
        String s = super.getText();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            this.myText = new SoftReference((Object)s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LazyParseableElement", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text = this.myText();
        CharSequence charSequence = text != null ? text : this.getText();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LazyParseableElement", "getChars"));
        }
        return charSequence;
    }

    @Override
    public int getTextLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getTextLength();
    }

    @Override
    public int getNotCachedLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getNotCachedLength();
    }

    @Override
    public int hc() {
        CharSequence text = this.myText();
        return text == null ? super.hc() : LeafElement.leafHC(text);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/tree/LazyParseableElement", "textMatches"));
        }
        CharSequence text = this.myText();
        if (text != null) {
            return LeafElement.leafTextMatches(text, buffer, start);
        }
        return super.textMatches(buffer, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsed() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return this.myParsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence myText() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return (CharSequence)this.myText.get();
        }
    }

    @Override
    final void setFirstChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child);
    }

    @Override
    final void setLastChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParsed() {
        CharSequence text;
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                return;
            }
            text = (CharSequence)this.myText.get();
            assert (text != null);
        }
        if (TreeUtil.getFileElement(this) == null) {
            LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DebugUtil.startPsiModification("lazy-parsing");
        try {
            ILazyParseableElementType type = (ILazyParseableElementType)this.getElementType();
            ASTNode parsedNode = type.parseContents((ASTNode)this);
            if (parsedNode == null && text.length() > 0) {
                CharSequence diagText = ApplicationManager.getApplication().isInternal() ? text : "";
                LOG.error("No parse for a non-empty string: " + diagText + "; type=" + LogUtil.objectAndClass((Object)type));
            }
            ChameleonLock chameleonLock2 = this.lock;
            synchronized (chameleonLock2) {
                block18: {
                    if (!this.myParsed) break block18;
                    return;
                }
                if (this.rawFirstChild() != null) {
                    LOG.error("Reentrant parsing?");
                }
                this.myParsed = true;
                if (parsedNode != null) {
                    super.rawAddChildrenWithoutNotifications((TreeElement)parsedNode);
                }
                AstPath.cacheNodePaths(this);
                this.myText = new SoftReference((Object)text);
            }
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/tree/LazyParseableElement", "rawAddChildrenWithoutNotifications"));
        }
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        CharSequence text = this.myText();
        if (text == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)text, (char[])buffer, (int)start);
        }
        return start + text.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static class ChameleonLock {
        private ChameleonLock() {
        }

        @NonNls
        public String toString() {
            return "chameleon parsing lock";
        }
    }
}

