/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubsHierarchy.impl.NamesEnumerator;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class NameEnvironment
extends UserDataHolderBase {
    public final QualifiedName empty;
    public final QualifiedName java_lang_Object;
    public final QualifiedName java_lang_Enum;
    public final QualifiedName[] annotation;
    public final NamesEnumerator myNamesEnumerator = new NamesEnumerator();

    public NameEnvironment() {
        this.empty = this.myNamesEnumerator.getFullName(new int[0], true);
        this.java_lang_Object = this.fromString("java.lang.Object", true);
        this.java_lang_Enum = this.fromString("java.lang.Enum", true);
        this.annotation = new QualifiedName[]{this.fromString("java.lang.annotation.Annotation", true)};
    }

    @Nullable
    public QualifiedName fromString(String s, boolean create) {
        List comps = StringUtil.split((String)s, (String)".");
        int[] ids = new int[comps.size()];
        for (int i = 0; i < comps.size(); ++i) {
            int name = this.simpleName((String)comps.get(i), create);
            if (name == 0) {
                return null;
            }
            ids[i] = name;
        }
        return this.myNamesEnumerator.getFullName(ids, create);
    }

    public int simpleName(String s, boolean create) {
        if (s == null) {
            return 0;
        }
        return this.myNamesEnumerator.getSimpleName(s, create);
    }

    public QualifiedName prefix(QualifiedName name) {
        if (name.myComponents.length <= 1) {
            return this.empty;
        }
        return this.myNamesEnumerator.getFullName(Arrays.copyOf(name.myComponents, name.myComponents.length - 1), true);
    }

    public QualifiedName qualifiedName(int id) {
        return this.myNamesEnumerator.qualifiedName(id);
    }

    public int shortName(QualifiedName name) {
        int[] ids = name.myComponents;
        return ids[ids.length - 1];
    }

    public QualifiedName qualifiedName(Symbol owner, int shortName) {
        if (shortName == 0 || owner == null || owner.myQualifiedName == null) {
            return null;
        }
        return this.qualifiedName(owner.myQualifiedName, shortName, true);
    }

    public QualifiedName qualifiedName(QualifiedName prefix, int shortName, boolean create) {
        if (shortName == 0) {
            return null;
        }
        if (prefix == null || prefix.isEmpty()) {
            return this.myNamesEnumerator.getFullName(new int[]{shortName}, create);
        }
        int[] ids = Arrays.copyOf(prefix.myComponents, prefix.myComponents.length + 1);
        ids[ids.length - 1] = shortName;
        return this.myNamesEnumerator.getFullName(ids, create);
    }

    QualifiedName concat(int[] ids, boolean create) {
        return this.myNamesEnumerator.getFullName(ids, create);
    }
}

