/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.unscramble.AnnotateStackTraceAction;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyzeStacktraceUtil {
    public static final ExtensionPointName<Filter> EP_NAME = ExtensionPointName.create((String)"com.intellij.analyzeStacktraceFilter");

    private AnalyzeStacktraceUtil() {
    }

    public static void printStacktrace(@NotNull ConsoleView consoleView, @NotNull String unscrambledTrace) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/unscramble/AnalyzeStacktraceUtil", "printStacktrace"));
        }
        if (unscrambledTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unscrambledTrace", "com/intellij/unscramble/AnalyzeStacktraceUtil", "printStacktrace"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String text = unscrambledTrace + "\n";
        String consoleText = ((ConsoleViewImpl)consoleView).getText();
        if (!text.equals(consoleText)) {
            consoleView.clear();
            consoleView.print(text, ConsoleViewContentType.ERROR_OUTPUT);
            consoleView.scrollTo(0);
        }
    }

    public static void addConsole(Project project2, @Nullable ConsoleFactory consoleFactory, String tabTitle, String text) {
        AnalyzeStacktraceUtil.addConsole(project2, consoleFactory, tabTitle, text, null);
    }

    public static RunContentDescriptor addConsole(Project project2, @Nullable ConsoleFactory consoleFactory, String tabTitle, String text, @Nullable Icon icon) {
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project2);
        builder.filters((Filter[])Extensions.getExtensions(EP_NAME, (AreaInstance)project2));
        ConsoleView consoleView = builder.getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JComponent consoleComponent = consoleFactory != null ? consoleFactory.createConsoleComponent(consoleView, toolbarActions) : new MyConsolePanel((ExecutionConsole)consoleView, (ActionGroup)toolbarActions);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleComponent, tabTitle, icon){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        for (AnAction action : consoleView.createConsoleActions()) {
            toolbarActions.add(action);
        }
        ConsoleViewImpl console = (ConsoleViewImpl)consoleView;
        ConsoleViewUtil.enableReplaceActionForConsoleViewEditor(console.getEditor());
        console.getEditor().getSettings().setCaretRowShown(true);
        toolbarActions.add((AnAction)new AnnotateStackTraceAction(console.getEditor(), console.getHyperlinks()));
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor, project2));
        ExecutionManager.getInstance((Project)project2).getContentManager().showRunContent(executor, descriptor);
        consoleView.allowHeavyFilters();
        if (consoleFactory == null) {
            AnalyzeStacktraceUtil.printStacktrace(consoleView, text);
        }
        return descriptor;
    }

    public static StacktraceEditorPanel createEditorPanel(Project project2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/unscramble/AnalyzeStacktraceUtil", "createEditorPanel"));
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document2 = editorFactory.createDocument((CharSequence)"");
        Editor editor = editorFactory.createEditor(document2, project2);
        EditorSettings settings = editor.getSettings();
        settings.setFoldingOutlineShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setRightMarginShown(false);
        StacktraceEditorPanel editorPanel = new StacktraceEditorPanel(project2, editor);
        editorPanel.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        Disposer.register((Disposable)parentDisposable, (Disposable)editorPanel);
        return editorPanel;
    }

    public static final class StacktraceEditorPanel
    extends JPanel
    implements DataProvider,
    Disposable {
        private final Project myProject;
        private final Editor myEditor;

        public StacktraceEditorPanel(Project project2, Editor editor) {
            super(new BorderLayout());
            this.myProject = project2;
            this.myEditor = editor;
            this.add(this.myEditor.getComponent());
        }

        public Object getData(String dataId) {
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return this.myEditor;
            }
            return null;
        }

        public Editor getEditor() {
            return this.myEditor;
        }

        public final void setText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/unscramble/AnalyzeStacktraceUtil$StacktraceEditorPanel", "setText"));
            }
            Runnable runnable2 = () -> {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/unscramble/AnalyzeStacktraceUtil$StacktraceEditorPanel", "lambda$setText$1"));
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/unscramble/AnalyzeStacktraceUtil$StacktraceEditorPanel", "lambda$null$0"));
                    }
                    Document document2 = this.myEditor.getDocument();
                    document2.replaceString(0, document2.getTextLength(), (CharSequence)StringUtil.convertLineSeparators((String)text));
                });
            };
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, "", (Object)this);
        }

        public void pasteTextFromClipboard() {
            String text = ClipboardUtil.getTextInClipboard();
            if (text != null) {
                this.setText(text);
            }
        }

        public void dispose() {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
        }

        public String getText() {
            return this.myEditor.getDocument().getText();
        }

        public JComponent getEditorComponent() {
            return this.myEditor.getContentComponent();
        }
    }

    private static final class MyConsolePanel
    extends JPanel {
        public MyConsolePanel(ExecutionConsole consoleView, ActionGroup toolbarActions) {
            super(new BorderLayout());
            JPanel toolbarPanel = new JPanel(new BorderLayout());
            toolbarPanel.add(ActionManager.getInstance().createActionToolbar("ANALYZE_STACKTRACE_PANEL_TOOLBAR", toolbarActions, false).getComponent());
            this.add((Component)toolbarPanel, "West");
            this.add((Component)consoleView.getComponent(), "Center");
        }
    }

    public static interface ConsoleFactory {
        public JComponent createConsoleComponent(ConsoleView var1, DefaultActionGroup var2);
    }
}

