/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.ByteSequenceDataExternalizer;
import com.intellij.util.indexing.ContentHashesSupport;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DebugAssertions;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InputIndexDataExternalizer;
import com.intellij.util.indexing.MapDiffUpdateData;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateData;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapReduceIndex<Key, Value, Input>
implements UpdatableIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.MapReduceIndex");
    private static final int NULL_MAPPING = 0;
    @Nullable
    private final ID<Key, Value> myIndexId;
    private final DataIndexer<Key, Value, Input> myIndexer;
    @NotNull
    protected final IndexStorage<Key, Value> myStorage;
    private final boolean myHasSnapshotMapping;
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataExternalizer<Collection<Key>> mySnapshotIndexExternalizer;
    private final boolean myIsPsiBackedIndex;
    private final IndexExtension<Key, Value, Input> myExtension;
    private final AtomicBoolean myInMemoryMode;
    private final TIntObjectHashMap<Collection<Key>> myInMemoryKeys;
    private PersistentHashMap<Integer, ByteSequence> myContents;
    private PersistentHashMap<Integer, Integer> myInputsSnapshotMapping;
    private PersistentHashMap<Integer, Collection<Key>> myInputsIndex;
    private PersistentHashMap<Integer, String> myIndexingTrace;
    private final ReentrantReadWriteLock myLock;
    private final LowMemoryWatcher myLowMemoryFlusher;
    private static final boolean doReadSavedPersistentData = SystemProperties.getBooleanProperty((String)"idea.read.saved.persistent.index", (boolean)true);
    private static final ThreadLocalCachedByteArray ourSpareByteArray = new ThreadLocalCachedByteArray();
    private static final Key<Integer> ourSavedContentHashIdKey = Key.create((String)"saved.content.hash.id");
    private static final Key<Integer> ourSavedUncommittedHashIdKey = Key.create((String)"saved.uncommitted.hash.id");
    private final UpdateData.RemovedOrUpdatedKeyProcessor<Key> myRemoveStaleKeyOperation;
    private final UpdateData.AddedKeyProcessor<Key, Value> myAddedKeyProcessor;

    public MapReduceIndex(IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage2) throws IOException {
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/indexing/MapReduceIndex", "<init>"));
        }
        this.myInMemoryMode = new AtomicBoolean();
        this.myInMemoryKeys = new TIntObjectHashMap();
        this.myLock = new ReentrantReadWriteLock();
        this.myLowMemoryFlusher = LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (MapReduceIndex.this.myStorage instanceof MemoryIndexStorage) {
                        MapReduceIndex.this.getWriteLock().lock();
                        try {
                            ((MemoryIndexStorage)MapReduceIndex.this.myStorage).clearCaches();
                        }
                        finally {
                            MapReduceIndex.this.getWriteLock().unlock();
                        }
                    }
                    MapReduceIndex.this.flush();
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                    FileBasedIndex.getInstance().requestRebuild(MapReduceIndex.this.myIndexId);
                }
            }
        });
        this.myRemoveStaleKeyOperation = new UpdateData.RemovedOrUpdatedKeyProcessor<Key>(){

            @Override
            public void process(Key key2, int inputId) throws StorageException {
                MapReduceIndex.this.myStorage.removeAllValues(key2, inputId);
            }
        };
        this.myAddedKeyProcessor = new UpdateData.AddedKeyProcessor<Key, Value>(){

            @Override
            public void process(Key key2, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.myStorage.addValue(key2, inputId, value);
            }
        };
        this.myIndexId = extension.getName();
        this.myExtension = extension;
        SharedIndicesData.registerIndex(this.myIndexId, extension);
        this.myIndexer = extension.getIndexer();
        this.myStorage = storage2;
        this.myHasSnapshotMapping = extension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)extension).hasSnapshotMapping() && IdIndex.ourSnapshotMappingsEnabled;
        this.mySnapshotIndexExternalizer = MapReduceIndex.createInputsIndexExternalizer(extension, this.myIndexId, extension.getKeyDescriptor());
        this.myValueExternalizer = extension.getValueExternalizer();
        this.myIsPsiBackedIndex = extension instanceof PsiDependentIndex;
        this.myContents = this.createContentsIndex();
        if (!SharedIndicesData.ourFileSharedIndicesEnabled || SharedIndicesData.DO_CHECKS) {
            if (this.myHasSnapshotMapping) {
                this.myInputsSnapshotMapping = this.createInputSnapshotMapping();
            } else {
                this.myInputsIndex = this.createInputsIndex();
            }
        }
        if (DebugAssertions.EXTRA_SANITY_CHECKS && this.myHasSnapshotMapping && this.myIndexId != null) {
            this.myIndexingTrace = this.createIndexingTrace();
        }
        if (storage2 instanceof MemoryIndexStorage) {
            ((MemoryIndexStorage)storage2).addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    MapReduceIndex.this.myInMemoryMode.set(newState);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void memoryStorageCleared() {
                    TIntObjectHashMap tIntObjectHashMap = MapReduceIndex.this.myInMemoryKeys;
                    synchronized (tIntObjectHashMap) {
                        MapReduceIndex.this.myInMemoryKeys.clear();
                    }
                }
            });
        }
    }

    private static <K> DataExternalizer<Collection<K>> createInputsIndexExternalizer(IndexExtension<K, ?, ?> extension, ID<K, ?> indexId, KeyDescriptor<K> keyDescriptor) {
        Object externalizer = extension instanceof CustomInputsIndexFileBasedIndexExtension ? ((CustomInputsIndexFileBasedIndexExtension)extension).createExternalizer() : new InputIndexDataExternalizer<K>(keyDescriptor, indexId);
        return externalizer;
    }

    @NotNull
    private static <K> PersistentHashMap<Integer, Collection<K>> createIdToDataKeysIndex(@NotNull IndexExtension<K, ?, ?> extension, @NotNull MemoryIndexStorage<K, ?> storage2) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/util/indexing/MapReduceIndex", "createIdToDataKeysIndex"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/indexing/MapReduceIndex", "createIdToDataKeysIndex"));
        }
        ID indexId = extension.getName();
        KeyDescriptor keyDescriptor = extension.getKeyDescriptor();
        File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile(indexId);
        PersistentHashMap persistentHashMap = new PersistentHashMap(indexStorageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, MapReduceIndex.createInputsIndexExternalizer(extension, indexId, keyDescriptor));
        if (persistentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "createIdToDataKeysIndex"));
        }
        return persistentHashMap;
    }

    private PersistentHashMap<Integer, ByteSequence> createContentsIndex() throws IOException {
        File saved;
        File file2 = saved = this.myHasSnapshotMapping && this.myIndexId != null ? new File(IndexInfrastructure.getPersistentIndexRootDir(this.myIndexId), "values") : null;
        if (saved != null) {
            try {
                return new PersistentHashMap(saved, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)ByteSequenceDataExternalizer.INSTANCE);
            }
            catch (IOException ex) {
                IOUtil.deleteAllFilesStartingWith((File)saved);
                throw ex;
            }
        }
        return null;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        IndexStorage<Key, Value> indexStorage = this.myStorage;
        if (indexStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getStorage"));
        }
        return indexStorage;
    }

    @Override
    public void clear() throws StorageException {
        try {
            this.getWriteLock().lock();
            this.myStorage.clear();
            if (this.myInputsIndex != null) {
                MapReduceIndex.cleanMapping(this.myInputsIndex);
                this.myInputsIndex = this.createInputsIndex();
            }
            if (this.myInputsSnapshotMapping != null) {
                MapReduceIndex.cleanMapping(this.myInputsSnapshotMapping);
                this.myInputsSnapshotMapping = this.createInputSnapshotMapping();
            }
            if (this.myIndexingTrace != null) {
                MapReduceIndex.cleanMapping(this.myIndexingTrace);
                this.myIndexingTrace = this.createIndexingTrace();
            }
            if (this.myContents != null) {
                MapReduceIndex.cleanMapping(this.myContents);
                this.myContents = this.createContentsIndex();
            }
        }
        catch (StorageException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private PersistentHashMap<Integer, Integer> createInputSnapshotMapping() throws IOException {
        assert (this.myIndexId != null);
        File fileIdToHashIdFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "fileIdToHashId");
        try {
            return new PersistentHashMap<Integer, Integer>(fileIdToHashIdFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE, 4096){

                protected boolean wantNonnegativeIntegralValues() {
                    return true;
                }
            };
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)fileIdToHashIdFile);
            throw ex;
        }
    }

    private PersistentHashMap<Integer, String> createIndexingTrace() throws IOException {
        assert (this.myIndexId != null);
        File mapFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "indextrace");
        try {
            return new PersistentHashMap(mapFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<String>(){

                public void save(@NotNull DataOutput out, String value) throws IOException {
                    if (out == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/MapReduceIndex$4", "save"));
                    }
                    out.write((byte[])CompressionUtil.compressCharSequence((CharSequence)value, (Charset)Charset.defaultCharset()));
                }

                public String read(@NotNull DataInput in) throws IOException {
                    if (in == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/indexing/MapReduceIndex$4", "read"));
                    }
                    byte[] b = new byte[((InputStream)((Object)in)).available()];
                    in.readFully(b);
                    return (String)CompressionUtil.uncompressCharSequence((Object)b, (Charset)Charset.defaultCharset());
                }
            }, 4096);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)mapFile);
            throw ex;
        }
    }

    private static void cleanMapping(@NotNull PersistentHashMap<?, ?> index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/util/indexing/MapReduceIndex", "cleanMapping"));
        }
        File baseFile = index.getBaseFile();
        try {
            index.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IOUtil.deleteAllFilesStartingWith((File)baseFile);
    }

    @Override
    public void flush() throws StorageException {
        try {
            this.getReadLock().lock();
            MapReduceIndex.doForce(this.myInputsIndex);
            MapReduceIndex.doForce(this.myInputsSnapshotMapping);
            MapReduceIndex.doForce(this.myIndexingTrace);
            MapReduceIndex.doForce(this.myContents);
            this.myStorage.flush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private static void doForce(PersistentHashMap<?, ?> inputsIndex) {
        if (inputsIndex != null && inputsIndex.isDirty()) {
            inputsIndex.force();
        }
    }

    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        Lock lock = this.getWriteLock();
        try {
            lock.lock();
            try {
                this.myStorage.close();
            }
            finally {
                MapReduceIndex.doClose(this.myInputsIndex);
                MapReduceIndex.doClose(this.myInputsSnapshotMapping);
                MapReduceIndex.doClose(this.myIndexingTrace);
                MapReduceIndex.doClose(this.myContents);
            }
        }
        catch (StorageException e) {
            LOG.error((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/MapReduceIndex", "setIndexedStateForFile"));
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, this.myIndexId);
    }

    @Override
    public void resetIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, this.myIndexId);
    }

    @Override
    public boolean isIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/MapReduceIndex", "isIndexedStateForFile"));
        }
        return IndexingStamp.isFileIndexedStateCurrent(fileId, this.myIndexId);
    }

    private static void doClose(PersistentHashMap<?, ?> index) {
        if (index != null) {
            try {
                index.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public final Lock getReadLock() {
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        if (readLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getReadLock"));
        }
        return readLock;
    }

    @Override
    @NotNull
    public final Lock getWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (writeLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getWriteLock"));
        }
        return writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllKeys(@NotNull Processor<Key> processor2, @NotNull GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/MapReduceIndex", "processAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/MapReduceIndex", "processAllKeys"));
        }
        Lock lock = this.getReadLock();
        try {
            lock.lock();
            boolean bl = this.myStorage.processKeys(processor2, scope, idFilter);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key2) throws StorageException {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/indexing/MapReduceIndex", "getData"));
        }
        Lock lock = this.getReadLock();
        lock.lock();
        ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
        ValueContainer<Value> valueContainer = this.myStorage.read(key2);
        ValueContainer<Value> valueContainer2 = valueContainer;
        if (valueContainer2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getData"));
        }
        return valueContainer2;
        finally {
            ValueContainerImpl.ourDebugIndexInfo.set(null);
            lock.unlock();
        }
    }

    protected PersistentHashMap<Integer, Collection<Key>> createInputsIndex() throws IOException {
        return MapReduceIndex.createIdToDataKeysIndex(this.myExtension, (MemoryIndexStorage)this.myStorage);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public final Computable<Boolean> update(final int inputId, @Nullable Input content) {
        weProcessPhysicalContent = content == null || content instanceof UserDataHolder != false && (Boolean)FileBasedIndexImpl.ourPhysicalContentKey.get((UserDataHolder)content, (Object)Boolean.FALSE) != false;
        data = null;
        havePersistentData = false;
        hashId = null;
        skippedReadingPersistentDataButMayHaveIt = false;
        if (this.myContents != null && weProcessPhysicalContent && content != null) {
            try {
                fileContent = (FileContent)content;
                hashId = this.getHashOfContent(fileContent);
                if (MapReduceIndex.doReadSavedPersistentData) {
                    if (!this.myContents.isBusyReading() || DebugAssertions.EXTRA_SANITY_CHECKS) {
                        bytes = this.readContents(hashId);
                        if (bytes != null) {
                            data = this.deserializeSavedPersistentData(bytes);
                            havePersistentData = true;
                            if (DebugAssertions.EXTRA_SANITY_CHECKS && !(sameValueForSavedIndexedResultAndCurrentOne = (contentData = this.myIndexer.map(content)).equals(data))) {
                                DebugAssertions.error("Unexpected difference in indexing of %s by index %s, file type %s, charset %s\ndiff %s\nprevious indexed info %s", new Object[]{fileContent.getFile(), this.myIndexId, fileContent.getFileType().getName(), ((FileContentImpl)fileContent).getCharset(), this.buildDiff(data, contentData), this.myIndexingTrace.get((Object)hashId)});
                            }
                        }
                    } else {
                        skippedReadingPersistentDataButMayHaveIt = true;
                    }
                } else {
                    havePersistentData = this.myContents.containsMapping((Object)hashId);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (data == null) {
            v0 = data = content != null ? this.myIndexer.map(content) : Collections.emptyMap();
            if (DebugAssertions.DEBUG) {
                this.checkValuesHaveProperEqualsAndHashCode(data);
            }
        }
        if (hashId != null && !havePersistentData) {
            saved = this.savePersistentData(data, hashId, skippedReadingPersistentDataButMayHaveIt);
            if (DebugAssertions.EXTRA_SANITY_CHECKS && saved) {
                fileContent = (FileContent)content;
                try {
                    this.myIndexingTrace.put((Object)hashId, (Object)(((FileContentImpl)fileContent).getCharset() + "," + fileContent.getFileType().getName() + "," + fileContent.getFile().getPath() + "," + ExceptionUtil.getThrowableText((Throwable)new Throwable())));
                }
                catch (IOException ex) {
                    MapReduceIndex.LOG.error((Throwable)ex);
                }
            }
        }
        ProgressManager.checkCanceled();
        optimizedUpdateData = null;
        if (this.myHasSnapshotMapping) {
            try {
                keysForGivenInputId = (NotNullComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$update$0(int ), ()Ljava/util/Collection;)((MapReduceIndex)this, (int)inputId);
                if (weProcessPhysicalContent) {
                    savedInputId = content instanceof FileContent != false ? this.getHashOfContent((FileContent)content) : 0;
                    oldKeysGetter = keysForGivenInputId;
                    if (!MapDiffUpdateData.ourDiffUpdateEnabled) ** GOTO lbl57
                    newValue = data;
                    optimizedUpdateData = new MapDiffUpdateData<Key, Value>(this.myIndexId){

                        @Override
                        protected Map<Key, Value> getNewValue() {
                            return newValue;
                        }

                        @Override
                        protected Map<Key, Value> getCurrentValue() throws IOException {
                            ByteSequence byteSequence;
                            Integer currentHashId = MapReduceIndex.this.readInputHashId(inputId);
                            Map currentValue = currentHashId != null ? ((byteSequence = MapReduceIndex.this.readContents(currentHashId)) != null ? MapReduceIndex.this.deserializeSavedPersistentData(byteSequence) : Collections.emptyMap()) : Collections.emptyMap();
                            return currentValue;
                        }

                        @Override
                        public void save(int inputId2) throws IOException {
                            MapReduceIndex.this.saveInputHashId(inputId2, savedInputId);
                        }
                    };
                }
                oldKeysGetter = (NotNullComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$update$1(int com.intellij.openapi.util.NotNullComputable ), ()Ljava/util/Collection;)((MapReduceIndex)this, (int)inputId, (NotNullComputable)keysForGivenInputId);
                savedInputId = 0;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            oldKeysGetter = (NotNullComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$update$2(int ), ()Ljava/util/Collection;)((MapReduceIndex)this, (int)inputId);
            savedInputId = inputId;
        }
lbl57:
        // 4 sources

        updateData = optimizedUpdateData != null ? optimizedUpdateData : this.buildUpdateData(data, oldKeysGetter, savedInputId);
        v1 = (Computable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$update$3(int com.intellij.util.indexing.UpdateData ), ()Ljava/lang/Boolean;)((MapReduceIndex)this, (int)inputId, updateData);
        if (v1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/util/indexing/MapReduceIndex", "update"}));
        }
        return v1;
    }

    protected UpdateData<Key, Value> buildUpdateData(Map<Key, Value> data, NotNullComputable<Collection<Key>> oldKeysGetter, int savedInputId) {
        return new SimpleUpdateData(this.myIndexId, savedInputId, data, oldKeysGetter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteSequence readContents(Integer hashId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentHashMap<Integer, ByteSequence> persistentHashMap = this.myContents;
                synchronized (persistentHashMap) {
                    ByteSequence contentBytes = SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
                    ByteSequence contentBytesFromContents = (ByteSequence)this.myContents.get((Object)hashId);
                    if (contentBytes == null && contentBytesFromContents != null || !Comparing.equal((Object)contentBytesFromContents, (Object)contentBytes)) {
                        SharedIndicesData.associateContentData(hashId, this.myIndexId, contentBytesFromContents, ByteSequenceDataExternalizer.INSTANCE);
                        if (contentBytes != null) {
                            LOG.error("Unexpected indexing diff with hashid " + this.myIndexId + "," + hashId);
                        }
                        contentBytes = contentBytesFromContents;
                    }
                    return contentBytes;
                }
            }
            return SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
        }
        return (ByteSequence)this.myContents.get((Object)hashId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContents(int id, BufferExposingByteArrayOutputStream out) throws IOException {
        ByteSequence byteSequence = new ByteSequence(out.getInternalBuffer(), 0, out.size());
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentHashMap<Integer, ByteSequence> persistentHashMap = this.myContents;
                synchronized (persistentHashMap) {
                    this.myContents.put((Object)id, (Object)byteSequence);
                    SharedIndicesData.associateContentData(id, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
                }
            } else {
                SharedIndicesData.associateContentData(id, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
            }
        } else {
            this.myContents.put((Object)id, (Object)byteSequence);
        }
    }

    private Integer readInputHashId(int inputId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            Integer hashId = (Integer)SharedIndicesData.recallFileData(inputId, this.myIndexId, EnumeratorIntegerDescriptor.INSTANCE);
            if (hashId == null) {
                hashId = 0;
            }
            if (this.myInputsSnapshotMapping == null) {
                return hashId;
            }
            Integer hashIdFromInputSnapshotMapping = (Integer)this.myInputsSnapshotMapping.get((Object)inputId);
            if (hashId == 0 && hashIdFromInputSnapshotMapping != 0 || !Comparing.equal((Object)hashIdFromInputSnapshotMapping, (Object)hashId)) {
                SharedIndicesData.associateFileData(inputId, this.myIndexId, hashIdFromInputSnapshotMapping, EnumeratorIntegerDescriptor.INSTANCE);
                if (hashId != 0) {
                    LOG.error("Unexpected indexing diff with hashid " + this.myIndexId + ", file:" + IndexInfrastructure.findFileById(PersistentFS.getInstance(), inputId) + "," + hashIdFromInputSnapshotMapping + "," + hashId);
                }
                hashId = hashIdFromInputSnapshotMapping;
            }
            return hashId;
        }
        return (Integer)this.myInputsSnapshotMapping.get((Object)inputId);
    }

    private void saveInputHashId(int inputId, int savedInputId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            SharedIndicesData.associateFileData(inputId, this.myIndexId, savedInputId, EnumeratorIntegerDescriptor.INSTANCE);
        }
        if (this.myInputsSnapshotMapping != null) {
            this.myInputsSnapshotMapping.put((Object)inputId, (Object)savedInputId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Key> readInputKeys(int inputId) throws IOException {
        if (this.myInMemoryMode.get()) {
            TIntObjectHashMap<Collection<Key>> tIntObjectHashMap = this.myInMemoryKeys;
            synchronized (tIntObjectHashMap) {
                Collection keys = (Collection)this.myInMemoryKeys.get(inputId);
                if (keys != null) {
                    return keys;
                }
            }
        }
        if (this.myHasSnapshotMapping) {
            return null;
        }
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            Collection keys = SharedIndicesData.recallFileData(inputId, this.myIndexId, this.mySnapshotIndexExternalizer);
            if (this.myInputsIndex != null) {
                Collection keysFromInputsIndex = (Collection)this.myInputsIndex.get((Object)inputId);
                if (keys == null && keysFromInputsIndex != null || !DebugAssertions.equals(keysFromInputsIndex, keys, this.myExtension.getKeyDescriptor())) {
                    SharedIndicesData.associateFileData(inputId, this.myIndexId, keysFromInputsIndex, this.mySnapshotIndexExternalizer);
                    if (keys != null) {
                        DebugAssertions.error("Unexpected indexing diff " + this.myIndexId + ", file:" + IndexInfrastructure.findFileById(PersistentFS.getInstance(), inputId) + "," + keysFromInputsIndex + "," + keys, new Object[0]);
                    }
                    keys = keysFromInputsIndex;
                }
            }
            return keys;
        }
        return (Collection)this.myInputsIndex.get((Object)inputId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInputKeys(int inputId, int savedInputId, Map<Key, Value> newData) throws IOException {
        if (this.myInMemoryMode.get()) {
            TIntObjectHashMap<Collection<Key>> tIntObjectHashMap = this.myInMemoryKeys;
            synchronized (tIntObjectHashMap) {
                this.myInMemoryKeys.put(inputId, newData.keySet());
            }
        } else if (this.myHasSnapshotMapping) {
            this.saveInputHashId(inputId, savedInputId);
        } else {
            if (this.myInputsIndex != null) {
                if (newData.size() > 0) {
                    this.myInputsIndex.put((Object)inputId, newData.keySet());
                } else {
                    this.myInputsIndex.remove((Object)inputId);
                }
            }
            if (SharedIndicesData.ourFileSharedIndicesEnabled) {
                Set<Key> newKeys = newData.keySet();
                if (newKeys.size() == 0) {
                    newKeys = null;
                }
                SharedIndicesData.associateFileData(inputId, this.myIndexId, newKeys, this.mySnapshotIndexExternalizer);
            }
        }
    }

    private void checkValuesHaveProperEqualsAndHashCode(Map<Key, Value> data) {
        for (Map.Entry<Key, Value> e : data.entrySet()) {
            Value value = e.getValue();
            if (!Comparing.equal(value, value) || value != null && value.hashCode() != value.hashCode()) {
                LOG.error("Index " + this.myIndexId.toString() + " violates equals / hashCode contract for Value parameter");
            }
            if (this.myValueExternalizer == null) continue;
            try {
                BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                DataOutputStream outputStream = new DataOutputStream((OutputStream)out);
                this.myValueExternalizer.save((DataOutput)outputStream, value);
                outputStream.close();
                Object deserializedValue = this.myValueExternalizer.read((DataInput)new DataInputStream((InputStream)new UnsyncByteArrayInputStream(out.getInternalBuffer(), 0, out.size())));
                if (Comparing.equal(value, (Object)deserializedValue) && (value == null || value.hashCode() == deserializedValue.hashCode())) continue;
                LOG.error("Index " + this.myIndexId.toString() + " deserialization violates equals / hashCode contract for Value parameter");
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    private StringBuilder buildDiff(Map<Key, Value> data, Map<Key, Value> contentData) {
        Value value;
        StringBuilder moreInfo = new StringBuilder();
        if (contentData.size() != data.size()) {
            moreInfo.append("Indexer has different number of elements, previously ").append(data.size()).append(" after ").append(contentData.size()).append("\n");
        } else {
            moreInfo.append("total ").append(contentData.size()).append(" entries\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : contentData.entrySet()) {
            if (!data.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("Previous data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value = data.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value)) continue;
            moreInfo.append("Previous data has different value for key:").append(keyValueEntry.getKey()).append(", new value ").append(keyValueEntry.getValue()).append(", oldValue:").append(value).append("\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : data.entrySet()) {
            if (!contentData.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("New data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value = contentData.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value)) continue;
            moreInfo.append("New data has different value for key:").append(keyValueEntry.getKey()).append(" new value ").append(value).append(", oldValue:").append(keyValueEntry.getValue()).append("\n");
        }
        return moreInfo;
    }

    private Map<Key, Value> deserializeSavedPersistentData(ByteSequence bytes) throws IOException {
        DataInputStream stream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes.getBytes(), bytes.getOffset(), bytes.getLength()));
        int pairs = DataInputOutputUtil.readINT((DataInput)stream);
        if (pairs == 0) {
            return Collections.emptyMap();
        }
        THashMap result2 = new THashMap(pairs);
        while (stream.available() > 0) {
            Object value = this.myValueExternalizer.read((DataInput)stream);
            Collection keys = (Collection)this.mySnapshotIndexExternalizer.read((DataInput)stream);
            for (Object k : keys) {
                result2.put(k, value);
            }
        }
        return result2;
    }

    private Integer getHashOfContent(FileContent content) throws IOException {
        Integer previouslyCalculatedContentHashId;
        FileType fileType = content.getFileType();
        if (this.myIsPsiBackedIndex && this.myHasSnapshotMapping && content instanceof FileContentImpl) {
            PsiDocumentManager psiDocumentManager;
            Document document2;
            Integer previouslyCalculatedUncommittedHashId = (Integer)content.getUserData(ourSavedUncommittedHashIdKey);
            if (previouslyCalculatedUncommittedHashId == null && (document2 = FileDocumentManager.getInstance().getCachedDocument(content.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)content.getProject())).isUncommited(document2)) {
                PsiFile file2 = psiDocumentManager.getCachedPsiFile(document2);
                Charset charset = ((FileContentImpl)content).getCharset();
                if (file2 != null) {
                    previouslyCalculatedUncommittedHashId = ContentHashesSupport.calcContentHashIdWithFileType(file2.getText().getBytes(charset), charset, fileType);
                    content.putUserData(ourSavedUncommittedHashIdKey, (Object)previouslyCalculatedUncommittedHashId);
                }
            }
            if (previouslyCalculatedUncommittedHashId != null) {
                return previouslyCalculatedUncommittedHashId;
            }
        }
        if ((previouslyCalculatedContentHashId = (Integer)content.getUserData(ourSavedContentHashIdKey)) == null) {
            byte[] hash;
            byte[] byArray = hash = content instanceof FileContentImpl ? ((FileContentImpl)content).getHash() : null;
            if (hash == null) {
                if (fileType.isBinary()) {
                    previouslyCalculatedContentHashId = ContentHashesSupport.calcContentHashId(content.getContent(), fileType);
                } else {
                    Charset charset = content instanceof FileContentImpl ? ((FileContentImpl)content).getCharset() : null;
                    previouslyCalculatedContentHashId = ContentHashesSupport.calcContentHashIdWithFileType(content.getContent(), charset, fileType);
                }
            } else {
                previouslyCalculatedContentHashId = ContentHashesSupport.enumerateHash(hash);
            }
            content.putUserData(ourSavedContentHashIdKey, (Object)previouslyCalculatedContentHashId);
        }
        return previouslyCalculatedContentHashId;
    }

    private boolean savePersistentData(Map<Key, Value> data, int id, boolean delayedReading) {
        try {
            if (delayedReading && this.myContents.containsMapping((Object)id)) {
                return false;
            }
            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(ourSpareByteArray.getBuffer(4 * data.size()));
            DataOutputStream stream = new DataOutputStream((OutputStream)out);
            int size = data.size();
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
            if (size > 0) {
                THashMap values = new THashMap();
                List keysForNullValue = null;
                for (Map.Entry<Key, Value> e : data.entrySet()) {
                    List keys;
                    Value value = e.getValue();
                    List list = keys = value != null ? (List)values.get(value) : keysForNullValue;
                    if (keys == null) {
                        if (value != null) {
                            keys = new SmartList();
                            values.put(value, (Object)keys);
                        } else {
                            keys = keysForNullValue = new SmartList();
                        }
                    }
                    keys.add(e.getKey());
                }
                if (keysForNullValue != null) {
                    this.myValueExternalizer.save((DataOutput)stream, null);
                    this.mySnapshotIndexExternalizer.save((DataOutput)stream, keysForNullValue);
                }
                for (Map.Entry<Object, Object> value : values.keySet()) {
                    this.myValueExternalizer.save((DataOutput)stream, value);
                    this.mySnapshotIndexExternalizer.save((DataOutput)stream, values.get(value));
                }
            }
            this.saveContents(id, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    public IndexExtension<Key, Value, Input> getExtension() {
        return this.myExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWithMap(int inputId, @NotNull UpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateData", "com/intellij/util/indexing/MapReduceIndex", "updateWithMap"));
        }
        this.getWriteLock().lock();
        try {
            try {
                ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
                updateData.iterateRemovedOrUpdatedKeys(inputId, this.myRemoveStaleKeyOperation);
                updateData.iterateAddedKeys(inputId, this.myAddedKeyProcessor);
                updateData.save(inputId);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable e) {
                throw new StorageException(e);
            }
            finally {
                ValueContainerImpl.ourDebugIndexInfo.set(null);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private /* synthetic */ Boolean lambda$update$3(int inputId, UpdateData updateData) {
        try {
            this.updateWithMap(inputId, updateData);
        }
        catch (ProcessCanceledException | StorageException ex) {
            LOG.info("Exception during updateWithMap:" + ex);
            FileBasedIndex.getInstance().requestRebuild(this.myIndexId, ex);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private /* synthetic */ Collection lambda$update$2(int inputId) {
        try {
            Collection<Key> oldKeys = this.readInputKeys(inputId);
            return oldKeys == null ? Collections.emptyList() : oldKeys;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ Collection lambda$update$1(int inputId, NotNullComputable keysForGivenInputId) {
        try {
            Collection<Key> oldKeys = this.readInputKeys(inputId);
            if (oldKeys == null) {
                return (Collection)keysForGivenInputId.compute();
            }
            return oldKeys;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ Collection lambda$update$0(int inputId) {
        try {
            ByteSequence byteSequence;
            Integer currentHashId = this.readInputHashId(inputId);
            Collection<Object> currentKeys = currentHashId != null ? ((byteSequence = this.readContents(currentHashId)) != null ? this.deserializeSavedPersistentData(byteSequence).keySet() : Collections.emptyList()) : Collections.emptyList();
            return currentKeys;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class SimpleUpdateData
    extends UpdateData<Key, Value> {
        private final int savedInputId;
        @NotNull
        private final Map<Key, Value> newData;
        @NotNull
        protected final NotNullComputable<Collection<Key>> oldKeysGetter;

        public SimpleUpdateData(ID<Key, Value> indexId, @NotNull int id, @NotNull Map<Key, Value> data, NotNullComputable<Collection<Key>> getter) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/util/indexing/MapReduceIndex$SimpleUpdateData", "<init>"));
            }
            if (getter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/util/indexing/MapReduceIndex$SimpleUpdateData", "<init>"));
            }
            super(indexId);
            this.savedInputId = id;
            this.newData = data;
            this.oldKeysGetter = getter;
        }

        @Override
        public void iterateRemovedOrUpdatedKeys(int inputId, UpdateData.RemovedOrUpdatedKeyProcessor<Key> consumer) throws StorageException {
            MapDiffUpdateData.iterateRemovedKeys((Collection)this.oldKeysGetter.compute(), inputId, consumer);
        }

        @Override
        public void iterateAddedKeys(int inputId, UpdateData.AddedKeyProcessor<Key, Value> consumer) throws StorageException {
            MapDiffUpdateData.iterateAddedKeyAndValues(inputId, consumer, this.newData);
        }

        @Override
        public void save(int inputId) throws IOException {
            MapReduceIndex.this.saveInputKeys(inputId, this.savedInputId, this.newData);
        }

        @NotNull
        public Map<Key, Value> getNewData() {
            Map map = this.newData;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex$SimpleUpdateData", "getNewData"));
            }
            return map;
        }
    }
}

