/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.stubs.ElementStub;
import java.lang.annotation.Annotation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedElementInvocationHandler
extends DomInvocationHandler<FixedChildDescriptionImpl, ElementStub> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.IndexedElementInvocationHandler");
    private final int myIndex;

    public IndexedElementInvocationHandler(EvaluatedXmlName tagName, FixedChildDescriptionImpl description, int index, DomParentStrategy strategy, DomManagerImpl manager, @Nullable ElementStub stub) {
        super(description.getType(), strategy, tagName, description, manager, strategy.isPhysical(), stub);
        this.myIndex = index;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.myIndex == ((IndexedElementInvocationHandler)((Object)obj)).myIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 239 + this.myIndex;
    }

    @Override
    @Nullable
    protected String getValue() {
        return this.myStub == null ? super.getValue() : ((ElementStub)this.myStub).getValue();
    }

    @Override
    protected XmlElement recomputeXmlElement(@NotNull DomInvocationHandler parentHandler) {
        if (parentHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentHandler", "com/intellij/util/xml/impl/IndexedElementInvocationHandler", "recomputeXmlElement"));
        }
        XmlTag tag = parentHandler.getXmlTag();
        if (tag == null) {
            return null;
        }
        List<XmlTag> tags = DomImplUtil.findSubTags(tag, this.getXmlName(), parentHandler.getFile());
        if (tags.size() <= this.myIndex) {
            return null;
        }
        return (XmlElement)tags.get(this.myIndex);
    }

    @Override
    protected XmlTag setEmptyXmlTag() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        FixedChildDescriptionImpl description = (FixedChildDescriptionImpl)this.getChildDescription();
        XmlFile xmlFile = this.getFile();
        parent.createFixedChildrenTags(this.getXmlName(), description, this.myIndex);
        List<XmlTag> tags = DomImplUtil.findSubTags(parent.getXmlTag(), this.getXmlName(), xmlFile);
        if (tags.size() > this.myIndex) {
            return tags.get(this.myIndex);
        }
        XmlTag[] newTag = new XmlTag[1];
        this.getManager().runChange(() -> {
            try {
                XmlTag parentTag = parent.getXmlTag();
                newTag[0] = (XmlTag)parentTag.add((PsiElement)parent.createChildTag(this.getXmlName()));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
        return newTag[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undefineInternal() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        XmlTag parentTag = parent.getXmlTag();
        if (parentTag == null) {
            return;
        }
        EvaluatedXmlName xmlElementName = this.getXmlName();
        FixedChildDescriptionImpl description = (FixedChildDescriptionImpl)this.getChildDescription();
        int totalCount = description.getCount();
        List<XmlTag> subTags = DomImplUtil.findSubTags(parentTag, xmlElementName, this.getFile());
        if (subTags.size() <= this.myIndex) {
            return;
        }
        XmlTag tag = this.getXmlTag();
        if (tag == null) {
            return;
        }
        boolean changing = this.getManager().setChanging(true);
        try {
            this.detach();
            if (totalCount == this.myIndex + 1 && subTags.size() >= this.myIndex + 1) {
                for (int i = this.myIndex; i < subTags.size(); ++i) {
                    subTags.get(i).delete();
                }
            } else if (subTags.size() == this.myIndex + 1) {
                tag.delete();
            } else {
                this.setXmlElement((XmlElement)((XmlTag)tag.replace((PsiElement)parent.createChildTag(this.getXmlName()))));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.getManager().setChanging(changing);
        }
        this.fireUndefinedEvent();
    }

    @Override
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = ((FixedChildDescriptionImpl)this.getChildDescription()).getAnnotation(this.myIndex, annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return this.getClassAnnotation(annotationClass);
    }

    @Override
    public final DomElement createPathStableCopy() {
        DomFixedChildDescription description = (DomFixedChildDescription)this.getChildDescription();
        DomElement parentCopy = this.getParent().createStableCopy();
        return this.getManager().createStableValue(() -> parentCopy.isValid() ? (DomElement)description.getValues(parentCopy).get(this.myIndex) : null);
    }
}

