/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.EmptyVisibleGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FakeVisiblePackBuilder {
    @NotNull
    private final VcsLogHashMap myHashMap;

    public FakeVisiblePackBuilder(@NotNull VcsLogHashMap hashMap) {
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "<init>"));
        }
        this.myHashMap = hashMap;
    }

    @NotNull
    public VisiblePack build(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "build"));
        }
        if (visiblePack.getVisibleGraph() instanceof VisibleGraphImpl) {
            VisiblePack visiblePack2 = this.build(visiblePack.getDataPack(), (VisibleGraphImpl)visiblePack.getVisibleGraph(), visiblePack.getFilters());
            if (visiblePack2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "build"));
            }
            return visiblePack2;
        }
        VisibleGraph<Integer> newGraph = EmptyVisibleGraph.getInstance();
        DataPackBase newPack = new DataPackBase(visiblePack.getDataPack().getLogProviders(), this.createEmptyRefsModel(), false);
        VisiblePack visiblePack3 = new VisiblePack(newPack, newGraph, true, visiblePack.getFilters());
        if (visiblePack3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "build"));
        }
        return visiblePack3;
    }

    @NotNull
    private VisiblePack build(@NotNull DataPackBase oldPack, @NotNull VisibleGraphImpl<Integer> oldGraph, @NotNull VcsLogFilterCollection filters) {
        if (oldPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPack", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "build"));
        }
        if (oldGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldGraph", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "build"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "build"));
        }
        SimpleGraphInfo<Integer> info = oldGraph.buildSimpleGraphInfo();
        Set heads = ContainerUtil.map2Set(info.getPermanentGraphLayout().getHeadNodeIndex(), integer -> (Integer)info.getPermanentCommitsInfo().getCommitId((int)integer));
        RefsModel newRefsModel = this.createRefsModel(oldPack.getRefsModel(), heads, oldGraph);
        DataPackBase newPack = new DataPackBase(oldPack.getLogProviders(), newRefsModel, false);
        GraphColorManagerImpl colorManager = new GraphColorManagerImpl(newRefsModel, DataPack.createHashGetter(this.myHashMap), DataPack.getRefManagerMap(oldPack.getLogProviders()));
        VisibleGraphImpl<Integer> newGraph = new VisibleGraphImpl<Integer>(new CollapsedController(new BaseController(info), info, null), info, colorManager);
        VisiblePack visiblePack = new VisiblePack(newPack, newGraph, true, filters);
        if (visiblePack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "build"));
        }
        return visiblePack;
    }

    @NotNull
    private RefsModel createEmptyRefsModel() {
        RefsModel refsModel = new RefsModel(ContainerUtil.newHashMap(), ContainerUtil.newHashSet(), this.myHashMap);
        if (refsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "createEmptyRefsModel"));
        }
        return refsModel;
    }

    private RefsModel createRefsModel(@NotNull RefsModel refsModel, @NotNull Set<Integer> heads, @NotNull VisibleGraph<Integer> visibleGraph) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "createRefsModel"));
        }
        if (heads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "createRefsModel"));
        }
        if (visibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "createRefsModel"));
        }
        List branchesAndHeads = ContainerUtil.filter(refsModel.getAllRefs(), ref -> {
            Integer row;
            if (heads == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "lambda$createRefsModel$1"));
            }
            if (visibleGraph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/data/FakeVisiblePackBuilder", "lambda$createRefsModel$1"));
            }
            int commitIndex = this.myHashMap.getCommitIndex(ref.getCommitHash(), ref.getRoot());
            return (ref.getType().isBranch() || heads.contains(commitIndex)) && (row = visibleGraph.getVisibleRowIndex((Object)commitIndex)) != null && row >= 0;
        });
        return new RefsModel(VcsLogUtil.groupRefsByRoot(branchesAndHeads), heads, this.myHashMap);
    }
}

