/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.google.common.collect.Iterables;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import gnu.trove.TIntObjectHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RefsModel
implements VcsLogRefs {
    @NotNull
    private final Collection<VcsRef> myBranches;
    @NotNull
    private final Map<VirtualFile, Set<VcsRef>> myRefs;
    @NotNull
    private final MultiMap<CommitId, VcsRef> myRefsToHashes;
    @NotNull
    private final TIntObjectHashMap<SmartList<VcsRef>> myBranchesToIndices;
    @NotNull
    private final TIntObjectHashMap<SmartList<VcsRef>> myRefsToHeadIndices;
    @NotNull
    private final TIntObjectHashMap<VirtualFile> myRootsToHeadIndices;

    public RefsModel(@NotNull Map<VirtualFile, Set<VcsRef>> refsByRoot, @NotNull Set<Integer> heads, @NotNull VcsLogHashMap hashMap) {
        if (refsByRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsByRoot", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        if (heads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        this.myRefs = refsByRoot;
        Iterable allRefs = Iterables.concat(refsByRoot.values());
        this.myBranches = ContainerUtil.newSmartList();
        for (VcsRef ref : allRefs) {
            if (!ref.getType().isBranch()) continue;
            this.myBranches.add(ref);
        }
        this.myRefsToHashes = RefsModel.prepareRefsMap(allRefs);
        this.myBranchesToIndices = RefsModel.prepareRefsToIndicesMap(this.myBranches, hashMap);
        this.myRefsToHeadIndices = RefsModel.prepareRefsToIndicesMap(Iterables.filter((Iterable)Iterables.concat(refsByRoot.values()), vcsRef -> {
            if (heads == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/data/RefsModel", "lambda$new$0"));
            }
            if (hashMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/RefsModel", "lambda$new$0"));
            }
            return heads.contains(hashMap.getCommitIndex(vcsRef.getCommitHash(), vcsRef.getRoot()));
        }), hashMap);
        this.myRootsToHeadIndices = RefsModel.prepareRootsMap(heads, hashMap);
    }

    @NotNull
    private static TIntObjectHashMap<VirtualFile> prepareRootsMap(@NotNull Set<Integer> heads, @NotNull VcsLogHashMap hashMap) {
        if (heads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/data/RefsModel", "prepareRootsMap"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/RefsModel", "prepareRootsMap"));
        }
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (Integer head : heads) {
            CommitId commitId = hashMap.getCommitId(head);
            if (commitId == null) continue;
            map.put(head.intValue(), (Object)commitId.getRoot());
        }
        TIntObjectHashMap tIntObjectHashMap = map;
        if (tIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "prepareRootsMap"));
        }
        return tIntObjectHashMap;
    }

    @NotNull
    private static TIntObjectHashMap<SmartList<VcsRef>> prepareRefsToIndicesMap(@NotNull Iterable<VcsRef> refs, @NotNull VcsLogHashMap hashMap) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/RefsModel", "prepareRefsToIndicesMap"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/RefsModel", "prepareRefsToIndicesMap"));
        }
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (VcsRef ref : refs) {
            int index = hashMap.getCommitIndex(ref.getCommitHash(), ref.getRoot());
            SmartList list = (SmartList)map.get(index);
            if (list == null) {
                list = new SmartList();
                map.put(index, (Object)list);
            }
            list.add((Object)ref);
        }
        TIntObjectHashMap tIntObjectHashMap = map;
        if (tIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "prepareRefsToIndicesMap"));
        }
        return tIntObjectHashMap;
    }

    @NotNull
    private static MultiMap<CommitId, VcsRef> prepareRefsMap(@NotNull Iterable<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/RefsModel", "prepareRefsMap"));
        }
        MultiMap map = MultiMap.createSmart();
        for (VcsRef ref : refs) {
            map.putValue((Object)new CommitId(ref.getCommitHash(), ref.getRoot()), (Object)ref);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "prepareRefsMap"));
        }
        return multiMap;
    }

    @NotNull
    public Collection<VcsRef> branchesToCommit(int index) {
        Collection<Object> collection = this.myBranchesToIndices.containsKey(index) ? (Collection)this.myBranchesToIndices.get(index) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "branchesToCommit"));
        }
        return collection;
    }

    @NotNull
    public Collection<VcsRef> refsToHead(int headIndex) {
        Collection<Object> collection = this.myRefsToHeadIndices.containsKey(headIndex) ? (Collection)this.myRefsToHeadIndices.get(headIndex) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "refsToHead"));
        }
        return collection;
    }

    @NotNull
    public VirtualFile rootAtHead(int headIndex) {
        VirtualFile virtualFile = (VirtualFile)this.myRootsToHeadIndices.get(headIndex);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "rootAtHead"));
        }
        return virtualFile;
    }

    @NotNull
    public Map<VirtualFile, Set<VcsRef>> getAllRefsByRoot() {
        Map<VirtualFile, Set<VcsRef>> map = this.myRefs;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getAllRefsByRoot"));
        }
        return map;
    }

    @NotNull
    public Collection<VcsRef> refsToCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        CommitId commitId = new CommitId(hash, root);
        if (this.myRefsToHashes.containsKey((Object)commitId)) {
            Collection collection = this.myRefsToHashes.get((Object)commitId);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
            }
            return collection;
        }
        List<VcsRef> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        return list;
    }

    @NotNull
    public Collection<VcsRef> getBranches() {
        Collection<VcsRef> collection = this.myBranches;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getBranches"));
        }
        return collection;
    }

    @NotNull
    public Collection<VcsRef> getAllRefs() {
        HashSet hashSet = ContainerUtil.newHashSet((Iterable)this.myRefsToHashes.values());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getAllRefs"));
        }
        return hashSet;
    }
}

