/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogProgress {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final List<ProgressListener> myListeners = ContainerUtil.newArrayList();
    private int myRunningTasksCount = 0;

    @NotNull
    public ProgressIndicator createProgressIndicator(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/vcs/log/data/VcsLogProgress", "createProgressIndicator"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
            if (emptyProgressIndicator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogProgress", "createProgressIndicator"));
            }
            return emptyProgressIndicator;
        }
        if (this.showProgressInLog()) {
            VcsLogProgressIndicator vcsLogProgressIndicator = new VcsLogProgressIndicator();
            if (vcsLogProgressIndicator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogProgress", "createProgressIndicator"));
            }
            return vcsLogProgressIndicator;
        }
        BackgroundableProcessIndicator backgroundableProcessIndicator = new BackgroundableProcessIndicator(task);
        if (backgroundableProcessIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogProgress", "createProgressIndicator"));
        }
        return backgroundableProcessIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressIndicatorListener(@NotNull ProgressListener listener2, @Nullable Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogProgress", "addProgressIndicatorListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.add(listener2);
            if (parentDisposable != null) {
                Disposer.register((Disposable)parentDisposable, () -> {
                    if (listener2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogProgress", "lambda$addProgressIndicatorListener$0"));
                    }
                    this.removeProgressIndicatorListener(listener2);
                });
            }
            if (this.isRunning()) {
                ApplicationManager.getApplication().invokeLater(listener2::progressStarted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressIndicatorListener(@NotNull ProgressListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogProgress", "removeProgressIndicatorListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myRunningTasksCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void started() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myRunningTasksCount;
            if (this.myRunningTasksCount == 1) {
                this.fireNotification(ProgressListener::progressStarted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped() {
        Object object = this.myLock;
        synchronized (object) {
            --this.myRunningTasksCount;
            if (this.myRunningTasksCount == 0) {
                this.fireNotification(ProgressListener::progressStopped);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotification(@NotNull Consumer<ProgressListener> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/data/VcsLogProgress", "fireNotification"));
        }
        Object object = this.myLock;
        synchronized (object) {
            ArrayList list = ContainerUtil.newArrayList(this.myListeners);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/data/VcsLogProgress", "lambda$fireNotification$1"));
                }
                list.forEach(action);
            });
        }
    }

    public boolean showProgressInLog() {
        return Registry.is((String)"vcs.log.keep.up.to.date");
    }

    public static interface ProgressListener {
        public void progressStarted();

        public void progressStopped();
    }

    private class VcsLogProgressIndicator
    extends AbstractProgressIndicatorBase {
        private VcsLogProgressIndicator() {
        }

        @Override
        public synchronized void start() {
            super.start();
            VcsLogProgress.this.started();
        }

        @Override
        public synchronized void stop() {
            super.stop();
            VcsLogProgress.this.stopped();
        }
    }
}

