/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class NonShortCircuitBooleanInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("NonShortCircuitBooleanExpression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection", "getID"));
        }
        return "NonShortCircuitBooleanExpression";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new NonShortCircuitBooleanFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonShortCircuitBooleanVisitor();
    }

    private static class NonShortCircuitBooleanVisitor
    extends BaseInspectionVisitor {
        private NonShortCircuitBooleanVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.AND) && !tokenType.equals(JavaTokenType.OR)) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiType.BOOLEAN)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class NonShortCircuitBooleanFix
    extends InspectionGadgetsFix {
        private NonShortCircuitBooleanFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection$NonShortCircuitBooleanFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection$NonShortCircuitBooleanFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiPolyadicExpression expression = (PsiPolyadicExpression)descriptor.getPsiElement();
            IElementType tokenType = expression.getOperationTokenType();
            String operandText = NonShortCircuitBooleanFix.getShortCircuitOperand(tokenType);
            PsiExpression[] operands = expression.getOperands();
            StringBuilder newExpression = new StringBuilder();
            for (PsiExpression operand : operands) {
                if (newExpression.length() != 0) {
                    newExpression.append(operandText);
                }
                newExpression.append(operand.getText());
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression.toString());
        }

        private static String getShortCircuitOperand(IElementType tokenType) {
            if (tokenType.equals(JavaTokenType.AND)) {
                return "&&";
            }
            return "||";
        }
    }
}

