/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class UseOfPropertiesAsHashtableInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("properties.object.as.hashtable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("properties.object.as.hashtable.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression[] arguments;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        String methodName = methodCallExpression.getMethodExpression().getReferenceName();
        boolean put = "put".equals(methodName);
        if (!put && !"get".equals(methodName)) {
            return null;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            PsiType type = argument.getType();
            if (type != null && type.equalsToText("java.lang.String")) continue;
            return null;
        }
        return new UseOfPropertiesAsHashtableFix(put);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfPropertiesAsHashtableVisitor();
    }

    private static class UseOfPropertiesAsHashtableVisitor
    extends BaseInspectionVisitor {
        private UseOfPropertiesAsHashtableVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection$UseOfPropertiesAsHashtableVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("put".equals(methodName) || "putAll".equals(methodName) || "get".equals(methodName))) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Hashtable")) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Properties")) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }
    }

    private static class UseOfPropertiesAsHashtableFix
    extends InspectionGadgetsFix {
        private final boolean put;

        public UseOfPropertiesAsHashtableFix(boolean put) {
            this.put = put;
        }

        @NotNull
        public String getName() {
            if (this.put) {
                String string = InspectionGadgetsBundle.message("properties.object.as.hashtable.set.quickfix", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection$UseOfPropertiesAsHashtableFix", "getName"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("properties.object.as.hashtable.get.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection$UseOfPropertiesAsHashtableFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Fix property access" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection$UseOfPropertiesAsHashtableFix", "getFamilyName"));
            }
            return "Fix property access";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            StringBuilder newExpression = new StringBuilder();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null) {
                newExpression.append(qualifierExpression.getText());
                newExpression.append('.');
            }
            if (this.put) {
                newExpression.append("setProperty(");
            } else {
                newExpression.append("getProperty(");
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            boolean first = true;
            for (PsiExpression argument : arguments) {
                if (!first) {
                    newExpression.append(',');
                } else {
                    first = false;
                }
                newExpression.append(argument.getText());
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString());
        }
    }
}

