/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementsWithoutDefaultInspection
extends BaseInspection {
    public boolean m_ignoreFullyCoveredEnums = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statements.without.default.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SwitchStatementsWithoutDefaultInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("SwitchStatementWithoutDefaultBranch" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SwitchStatementsWithoutDefaultInspection", "getID"));
        }
        return "SwitchStatementWithoutDefaultBranch";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("switch.statements.without.default.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SwitchStatementsWithoutDefaultInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("switch.statement.without.default.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreFullyCoveredEnums");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementsWithoutDefaultVisitor();
    }

    private class SwitchStatementsWithoutDefaultVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementsWithoutDefaultVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementsWithoutDefaultInspection$SwitchStatementsWithoutDefaultVisitor", "visitSwitchStatement"));
            }
            super.visitSwitchStatement(statement2);
            if (this.switchStatementHasDefault(statement2)) {
                return;
            }
            if (SwitchStatementsWithoutDefaultInspection.this.m_ignoreFullyCoveredEnums && this.switchStatementIsFullyCoveredEnum(statement2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        private boolean switchStatementHasDefault(PsiSwitchStatement statement2) {
            PsiCodeBlock body = statement2.getBody();
            if (body == null) {
                return true;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return true;
            }
            for (PsiStatement child : statements) {
                PsiSwitchLabelStatement switchLabelStatement;
                if (!(child instanceof PsiSwitchLabelStatement) || !(switchLabelStatement = (PsiSwitchLabelStatement)child).isDefaultCase()) continue;
                return true;
            }
            return false;
        }

        private boolean switchStatementIsFullyCoveredEnum(PsiSwitchStatement statement2) {
            PsiExpression expression = statement2.getExpression();
            if (expression == null) {
                return false;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null || !aClass.isEnum()) {
                return false;
            }
            PsiCodeBlock body = statement2.getBody();
            if (body == null) {
                return false;
            }
            PsiStatement[] statements = body.getStatements();
            int numCases = 0;
            for (PsiStatement child : statements) {
                if (!(child instanceof PsiSwitchLabelStatement)) continue;
                ++numCases;
            }
            PsiField[] fields = aClass.getFields();
            int numEnums = 0;
            for (PsiField field : fields) {
                PsiType fieldType = field.getType();
                if (!fieldType.equals(type)) continue;
                ++numEnums;
            }
            return numEnums == numCases;
        }
    }
}

