/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class IntroduceConstantFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/IntroduceConstantFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("introduce.constant.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/IntroduceConstantFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(@NotNull Project project2, ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/fixes/IntroduceConstantFix", "doFix"));
        }
        PsiElement constant = descriptor.getPsiElement();
        JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
        RefactoringActionHandler introduceHandler = factory.createIntroduceConstantHandler();
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = dataManager.getDataContext();
        introduceHandler.invoke(project2, new PsiElement[]{constant}, dataContext);
    }

    @Override
    protected boolean prepareForWriting() {
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

