/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpModifierProvider;
import org.jetbrains.annotations.NotNull;

public class CheckRegExpForm {
    private static final String LAST_EDITED_REGEXP = "last.edited.regexp";
    private static final JBColor BACKGROUND_COLOR_MATCH = new JBColor(15203035, 0x445542);
    private static final JBColor BACKGROUND_COLOR_NOMATCH = new JBColor(16757152, 7220008);
    private final PsiFile myRegexpFile;
    private EditorTextField mySampleText;
    private EditorTextField myRegExp;
    private JPanel myRootPanel;
    private JBLabel myMessage;
    private Project myProject;

    public CheckRegExpForm(@NotNull PsiFile regexpFile) {
        if (regexpFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexpFile", "org/intellij/lang/regexp/intention/CheckRegExpForm", "<init>"));
        }
        this.myRegexpFile = regexpFile;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.myProject = this.myRegexpFile.getProject();
        Document document2 = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myRegexpFile);
        this.myRegExp = new EditorTextField(document2, this.myProject, (FileType)RegExpLanguage.INSTANCE.getAssociatedFileType());
        String sampleText = PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_EDITED_REGEXP, "Sample Text");
        this.mySampleText = new EditorTextField(sampleText, this.myProject, (FileType)PlainTextFileType.INSTANCE){

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/lang/regexp/intention/CheckRegExpForm$1", "updateBorder"));
                }
                this.setupBorder(editor);
            }
        };
        this.mySampleText.setOneLineMode(false);
        int preferredWidth = Math.max(JBUI.scale((int)250), this.myRegExp.getPreferredSize().width);
        this.myRegExp.setPreferredWidth(preferredWidth);
        this.mySampleText.setPreferredWidth(preferredWidth);
        this.myRootPanel = new JPanel(new BorderLayout()){
            Disposable disposable;

            @Override
            public void addNotify() {
                super.addNotify();
                this.disposable = Disposer.newDisposable();
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)CheckRegExpForm.this.mySampleText), true);
                new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        IdeFocusManager.findInstance().requestFocus((Component)CheckRegExpForm.this.myRegExp.getFocusTarget(), true);
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)((Object)CheckRegExpForm.this.mySampleText));
                final Alarm updater = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.disposable);
                DocumentAdapter documentListener = new DocumentAdapter(){

                    public void documentChanged(DocumentEvent e) {
                        updater.cancelAllRequests();
                        if (!updater.isDisposed()) {
                            updater.addRequest(() -> CheckRegExpForm.this.updateBalloon(), 200);
                        }
                    }
                };
                CheckRegExpForm.this.myRegExp.addDocumentListener((DocumentListener)documentListener);
                CheckRegExpForm.this.mySampleText.addDocumentListener((DocumentListener)documentListener);
                CheckRegExpForm.this.updateBalloon();
                CheckRegExpForm.this.mySampleText.selectAll();
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)this.disposable);
                PropertiesComponent.getInstance((Project)CheckRegExpForm.this.myProject).setValue(CheckRegExpForm.LAST_EDITED_REGEXP, CheckRegExpForm.this.mySampleText.getText());
            }
        };
        this.myRootPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.mySampleText;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/intention/CheckRegExpForm", "getPreferredFocusedComponent"));
        }
        return editorTextField;
    }

    @NotNull
    public JPanel getRootPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/intention/CheckRegExpForm", "getRootPanel"));
        }
        return jPanel;
    }

    private void updateBalloon() {
        Boolean correct = CheckRegExpForm.isMatchingText(this.myRegexpFile, this.mySampleText.getText());
        ApplicationManager.getApplication().invokeLater(() -> {
            this.mySampleText.setBackground((Color)(correct != null && correct != false ? BACKGROUND_COLOR_MATCH : BACKGROUND_COLOR_NOMATCH));
            this.myMessage.setText(correct == null ? "Pattern is too complex" : (correct != false ? "Matches!" : "No match"));
            this.myRootPanel.revalidate();
            Balloon balloon = JBPopupFactory.getInstance().getParentBalloonFor((Component)this.myRootPanel);
            if (balloon != null) {
                balloon.revalidate();
            }
        }, ModalityState.current());
    }

    public static boolean isMatchingTextTest(@NotNull PsiFile regexpFile, @NotNull String sampleText) {
        if (regexpFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexpFile", "org/intellij/lang/regexp/intention/CheckRegExpForm", "isMatchingTextTest"));
        }
        if (sampleText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleText", "org/intellij/lang/regexp/intention/CheckRegExpForm", "isMatchingTextTest"));
        }
        Boolean result2 = CheckRegExpForm.isMatchingText(regexpFile, sampleText);
        return result2 != null && result2 != false;
    }

    private static Boolean isMatchingText(final @NotNull PsiFile regexpFile, @NotNull String sampleText) {
        if (regexpFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexpFile", "org/intellij/lang/regexp/intention/CheckRegExpForm", "isMatchingText"));
        }
        if (sampleText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleText", "org/intellij/lang/regexp/intention/CheckRegExpForm", "isMatchingText"));
        }
        String regExp = regexpFile.getText();
        Integer patternFlags = (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

            public Integer compute() {
                int flags;
                block1: {
                    RegExpModifierProvider provider;
                    PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)regexpFile);
                    flags = 0;
                    if (host == null) break block1;
                    Iterator iterator = RegExpModifierProvider.EP.allForLanguage(host.getLanguage()).iterator();
                    while (iterator.hasNext() && (flags = (provider = (RegExpModifierProvider)iterator.next()).getFlags((PsiElement)host, regexpFile)) <= 0) {
                    }
                }
                return flags;
            }
        });
        try {
            return Pattern.compile(regExp, patternFlags).matcher(StringUtil.newBombedCharSequence((CharSequence)sampleText, (long)1000L)).matches();
        }
        catch (ProcessCanceledException pc) {
            return null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        this.createUIComponents();
        JPanel jPanel = this.myRootPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMessage = jBLabel = new JBLabel();
        jBLabel.setText("Red means I can't hear you!");
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 2, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("RegExp:");
        jLabel.setPreferredSize(new Dimension(55, 16));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Sample:");
        jLabel2.setPreferredSize(new Dimension(55, 16));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myRegExp;
        jPanel.add((Component)((Object)editorTextField), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        EditorTextField editorTextField2 = this.mySampleText;
        jPanel.add((Component)((Object)editorTextField2), new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

