/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import gnu.trove.THashSet;
import gnu.trove.TObjectProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.webSocket.WebSocketServerOptions;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0019J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u0014\u0010\u001e\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0 J\u0006\u0010!\u001a\u00020\u0019J@\u0010\"\u001a\u00020\u0016\"\u0004\b\u0000\u0010#2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\"\b\u0002\u0010'\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H#0*0)\u0018\u00010(R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/io/jsonRpc/ClientManager;", "Lcom/intellij/openapi/Disposable;", "listener", "Lorg/jetbrains/io/jsonRpc/ClientListener;", "exceptionHandler", "Lorg/jetbrains/io/jsonRpc/ExceptionHandler;", "options", "Lorg/jetbrains/io/webSocket/WebSocketServerOptions;", "(Lorg/jetbrains/io/jsonRpc/ClientListener;Lorg/jetbrains/io/jsonRpc/ExceptionHandler;Lorg/jetbrains/io/webSocket/WebSocketServerOptions;)V", "clientCount", "", "getClientCount", "()I", "clients", "Lgnu/trove/THashSet;", "Lorg/jetbrains/io/jsonRpc/Client;", "getExceptionHandler", "()Lorg/jetbrains/io/jsonRpc/ExceptionHandler;", "heartbeatTimer", "Lcom/intellij/openapi/util/SimpleTimerTask;", "Lorg/jetbrains/annotations/NotNull;", "addClient", "", "client", "disconnectClient", "", "channel", "Lio/netty/channel/Channel;", "closeChannel", "dispose", "forEachClient", "procedure", "Lgnu/trove/TObjectProcedure;", "hasClients", "send", "T", "messageId", "message", "Lio/netty/buffer/ByteBuf;", "results", "", "Lorg/jetbrains/concurrency/Promise;", "Lkotlin/Pair;", "built-in-server"})
public final class ClientManager
implements Disposable {
    private final SimpleTimerTask heartbeatTimer;
    private final THashSet<Client> clients;
    private final ClientListener listener;
    @NotNull
    private final ExceptionHandler exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addClient(@NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            boolean bl = this.clients.add((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getClientCount() {
        int n;
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            n = this.clients.size();
        }
        return n;
    }

    public final boolean hasClients() {
        return this.getClientCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.heartbeatTimer.cancel();
        }
        finally {
            THashSet<Client> tHashSet = this.clients;
            synchronized (tHashSet) {
                this.clients.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final <T> void send(int messageId, @NotNull ByteBuf message, @Nullable List<Promise<Pair<Client, T>>> results) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.forEachClient((TObjectProcedure<Client>)((TObjectProcedure)new TObjectProcedure<Client>(this, messageId, message, results){
            private boolean first;
            final /* synthetic */ ClientManager this$0;
            final /* synthetic */ int $messageId;
            final /* synthetic */ ByteBuf $message;
            final /* synthetic */ List $results;

            public boolean execute(@NotNull Client client) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
                try {
                    Boolean bl;
                    AsyncPromise<T> result2 = client.send(this.$messageId, this.first ? this.$message : this.$message.duplicate());
                    this.first = false;
                    List list = this.$results;
                    if (list != null) {
                        AsyncPromise<T> asyncPromise = result2;
                        if (asyncPromise == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull(asyncPromise, (String)"result!!");
                        bl = list.add(asyncPromise);
                    } else {
                        bl = null;
                    }
                }
                catch (Throwable e) {
                    this.this$0.getExceptionHandler().exceptionCaught(e);
                }
                return true;
            }
            {
                this.this$0 = $outer;
                this.$messageId = $captured_local_variable$1;
                this.$message = $captured_local_variable$2;
                this.$results = $captured_local_variable$3;
            }
        }));
    }

    public static /* bridge */ /* synthetic */ void send$default(ClientManager clientManager, int n, ByteBuf byteBuf, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: send");
        }
        if ((n2 & 4) != 0) {
            list = null;
        }
        clientManager.send(n, byteBuf, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean disconnectClient(@NotNull Channel channel, @NotNull Client client, boolean closeChannel) {
        Unit unit;
        ClientListener clientListener;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            block11: {
                if (this.clients.remove((Object)client)) break block11;
                boolean bl = false;
                return bl;
            }
            Unit unit2 = Unit.INSTANCE;
        }
        try {
            channel.attr(ClientManagerKt.getCLIENT()).remove();
            if (closeChannel) {
                channel.close();
            }
            client.rejectAsyncResults(this.exceptionHandler);
            clientListener = this.listener;
        }
        catch (Throwable throwable) {
            Unit unit3;
            ClientListener clientListener2 = this.listener;
            if (clientListener2 != null) {
                clientListener2.disconnected(client);
                unit3 = Unit.INSTANCE;
            } else {
                unit3 = null;
            }
            throw throwable;
        }
        if (clientListener != null) {
            clientListener.disconnected(client);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachClient(@NotNull TObjectProcedure<Client> procedure) {
        Intrinsics.checkParameterIsNotNull(procedure, (String)"procedure");
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            boolean bl = this.clients.forEach(procedure);
        }
    }

    @NotNull
    public final ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public ClientManager(@Nullable ClientListener listener2, @NotNull ExceptionHandler exceptionHandler, @Nullable WebSocketServerOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)exceptionHandler, (String)"exceptionHandler");
        this.listener = listener2;
        this.exceptionHandler = exceptionHandler;
        SimpleTimer simpleTimer = SimpleTimer.getInstance();
        Runnable runnable2 = new Runnable(this){
            final /* synthetic */ ClientManager this$0;

            public final void run() {
                this.this$0.forEachClient((TObjectProcedure<Client>)((TObjectProcedure)heartbeatTimer.1.INSTANCE));
            }
            {
                this.this$0 = clientManager;
            }
        };
        WebSocketServerOptions webSocketServerOptions = options;
        if (webSocketServerOptions == null) {
            webSocketServerOptions = new WebSocketServerOptions();
        }
        this.heartbeatTimer = simpleTimer.setUp(runnable2, (long)webSocketServerOptions.heartbeatDelay);
        this.clients = new THashSet();
    }

    public /* synthetic */ ClientManager(ClientListener clientListener, ExceptionHandler exceptionHandler, WebSocketServerOptions webSocketServerOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            webSocketServerOptions = null;
        }
        this(clientListener, exceptionHandler, webSocketServerOptions);
    }
}

