/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.BindingTarget;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.FieldAccessExpr;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.store.Location;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.FlagSet;
import android.databinding.tool.writer.KCode;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function2;

public class InverseBinding
implements LocationScopeProvider {
    private final String mName;
    private final Expr mExpr;
    private final BindingTarget mTarget;
    private SetterStore.BindingGetterCall mGetterCall;
    private final ArrayList<FieldAccessExpr> mChainedExpressions = new ArrayList();

    public InverseBinding(BindingTarget target, String name, Expr expr) {
        this.mTarget = target;
        this.mName = name;
        this.mExpr = expr;
    }

    @Override
    public List<Location> provideScopeLocation() {
        if (this.mExpr != null) {
            return this.mExpr.getLocations();
        }
        return this.mChainedExpressions.get(0).getLocations();
    }

    void setGetterCall(SetterStore.BindingGetterCall getterCall) {
        this.mGetterCall = getterCall;
    }

    public void addChainedExpression(FieldAccessExpr expr) {
        this.mChainedExpressions.add(expr);
    }

    public boolean isOnBinder() {
        return this.mTarget.getResolvedType().isViewDataBinding();
    }

    private SetterStore.BindingGetterCall getGetterCall() {
        if (this.mGetterCall == null) {
            if (this.mExpr != null) {
                this.mExpr.getResolvedType();
            }
            try {
                Scope.enter(this.mTarget);
                Scope.enter(this);
                this.resolveGetterCall();
                if (this.mGetterCall == null) {
                    L.e("Cannot find the getter for attribute '%s' with value type %s on %s.", this.mName, this.mExpr == null ? "Unknown" : this.mExpr.getResolvedType(), this.mTarget.getResolvedType());
                }
            }
            finally {
                Scope.exit();
                Scope.exit();
            }
        }
        return this.mGetterCall;
    }

    private void resolveGetterCall() {
        ModelClass viewType = this.mTarget.getResolvedType();
        SetterStore setterStore = SetterStore.get(ModelAnalyzer.getInstance());
        ModelClass resolvedType = this.mExpr == null ? null : this.mExpr.getResolvedType();
        this.mGetterCall = setterStore.getGetterCall(this.mName, viewType, resolvedType, this.getModel().getImports());
    }

    public BindingTarget getTarget() {
        return this.mTarget;
    }

    public KCode toJavaCode(String bindingComponent, FlagSet flagField) {
        String targetViewName = LayoutBinderWriterKt.getFieldName(this.getTarget());
        KCode code = new KCode();
        Preconditions.check(this.mExpr == null != this.mChainedExpressions.isEmpty(), "Chained expressions are only against unbound attributes.", new Object[0]);
        if (this.mExpr != null) {
            code.app("", this.mExpr.toInverseCode(new KCode(this.getGetterCall().toJava(bindingComponent, targetViewName))));
        } else {
            final String fieldName2 = flagField.getLocalName();
            FlagSet flagSet = new FlagSet(new int[0]);
            for (FieldAccessExpr expr : this.mChainedExpressions) {
                flagSet = flagSet.or(new FlagSet(expr.getId()));
            }
            final FlagSet allFlags = flagSet;
            code.nl(new KCode("synchronized(this) {"));
            code.tab(LayoutBinderWriterKt.mapOr(flagField, flagSet, new Function2<String, Integer, KCode>(){

                public KCode invoke(String suffix, Integer index) {
                    return new KCode(fieldName2).app(suffix).app(" |= ").app(LayoutBinderWriterKt.binaryCode(allFlags, index)).app(";");
                }
            }));
            code.nl(new KCode("}"));
            code.nl(new KCode("requestRebind()"));
        }
        return code;
    }

    public String getBindingAdapterInstanceClass() {
        return this.getGetterCall().getBindingAdapterInstanceClass();
    }

    public int getMinApi() {
        SetterStore.BindingGetterCall getterCall = this.getGetterCall();
        return Math.max(getterCall.getMinApi(), getterCall.getEvent().getMinApi());
    }

    public SetterStore.BindingSetterCall getEventSetter() {
        SetterStore.BindingGetterCall getterCall = this.getGetterCall();
        return getterCall.getEvent();
    }

    public String getName() {
        return this.mName;
    }

    public String getEventAttribute() {
        return this.getGetterCall().getEventAttribute();
    }

    public ExprModel getModel() {
        if (this.mExpr != null) {
            return this.mExpr.getModel();
        }
        return this.mChainedExpressions.get(0).getModel();
    }
}

