/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import jspecview.api.JSVPrintDialog;
import jspecview.common.PrintLayout;

public class AwtPrintDialog
extends JDialog
implements JSVPrintDialog {
    private static final long serialVersionUID = 1L;
    private ButtonGroup layoutButtonGroup = new ButtonGroup();
    private ButtonGroup fontButtonGroup = new ButtonGroup();
    private ButtonGroup positionButtonGroup = new ButtonGroup();
    private PrintLayout pl;
    private PrintLayout plNew;
    private JButton previewButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton printButton = new JButton();
    private JButton pdfButton = new JButton();
    private JCheckBox scaleXCheckBox = new JCheckBox();
    private JCheckBox scaleYCheckBox = new JCheckBox();
    private JCheckBox gridCheckBox = new JCheckBox();
    private JCheckBox titleCheckBox = new JCheckBox();
    private JRadioButton landscapeRadioButton = new JRadioButton();
    private JRadioButton topLeftRadioButton = new JRadioButton();
    private JRadioButton centerRadioButton = new JRadioButton();
    private JRadioButton portraitRadioButton = new JRadioButton();
    private JRadioButton fitToPageRadioButton = new JRadioButton();
    private JRadioButton chooseFontRadioButton = new JRadioButton();
    private JRadioButton defaultFontRadioButton = new JRadioButton();
    private static JComboBox<MediaSizeName> paperComboBox = new JComboBox();
    private static ImageIcon previewPortraitCenterIcon;
    private static ImageIcon previewPortraitDefaultIcon;
    private static ImageIcon previewPortraitFitIcon;
    private static ImageIcon previewLandscapeCenterIcon;
    private static ImageIcon previewLandscapeDefaultIcon;
    private static ImageIcon previewLandscapeFitIcon;

    public AwtPrintDialog() {
        super((Frame)null, "Print layout", true);
    }

    @Override
    public AwtPrintDialog set(Object frame, PrintLayout pl, boolean isJob) {
        if (pl == null) {
            pl = new PrintLayout();
        }
        this.pl = pl;
        try {
            this.jbInit(isJob);
            this.setSize(320, 250);
            this.setResizable(false);
            this.pack();
            this.pdfButton.requestFocusInWindow();
            this.setVisible(true);
            return this;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static void setStaticElements() {
        if (previewLandscapeFitIcon != null) {
            return;
        }
        paperComboBox.addItem(MediaSizeName.NA_LETTER);
        paperComboBox.addItem(MediaSizeName.NA_LEGAL);
        paperComboBox.addItem(MediaSizeName.ISO_A4);
        paperComboBox.addItem(MediaSizeName.ISO_B4);
        previewPortraitCenterIcon = AwtPrintDialog.getIcon("portraitCenter");
        previewPortraitDefaultIcon = AwtPrintDialog.getIcon("portraitDefault");
        previewPortraitFitIcon = AwtPrintDialog.getIcon("portraitFit");
        previewLandscapeCenterIcon = AwtPrintDialog.getIcon("landscapeCenter");
        previewLandscapeDefaultIcon = AwtPrintDialog.getIcon("landscapeDefault");
        previewLandscapeFitIcon = AwtPrintDialog.getIcon("landscapeFit");
    }

    private static ImageIcon getIcon(String name) {
        return new ImageIcon(AwtPrintDialog.class.getResource("icons/" + name + ".gif"));
    }

    private void jbInit(boolean isJob) throws Exception {
        this.layoutButtonGroup.add(this.portraitRadioButton);
        this.layoutButtonGroup.add(this.landscapeRadioButton);
        this.positionButtonGroup.add(this.centerRadioButton);
        this.positionButtonGroup.add(this.fitToPageRadioButton);
        this.positionButtonGroup.add(this.topLeftRadioButton);
        this.fontButtonGroup.add(this.defaultFontRadioButton);
        this.fontButtonGroup.add(this.chooseFontRadioButton);
        AwtPrintDialog.setStaticElements();
        TitledBorder layoutBorder = new TitledBorder("Layout");
        layoutBorder.setTitleJustification(2);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwtPrintDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.printButton.setToolTipText("");
        this.printButton.setText("Print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwtPrintDialog.this.printButton_actionPerformed(false);
            }
        });
        this.pdfButton.setToolTipText("");
        this.pdfButton.setText("Create PDF");
        this.pdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwtPrintDialog.this.printButton_actionPerformed(true);
            }
        });
        JPanel layoutContentPanel = new JPanel();
        JPanel layoutPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        layoutPanel.setBorder(layoutBorder);
        layoutPanel.setLayout(new GridBagLayout());
        this.landscapeRadioButton.setActionCommand("Landscape");
        this.landscapeRadioButton.setText("Landscape");
        this.landscapeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwtPrintDialog.this.landscapeRadioButton_actionPerformed(e);
            }
        });
        layoutContentPanel.setLayout(new GridBagLayout());
        this.scaleXCheckBox.setText("X-Scale");
        this.scaleYCheckBox.setText("Y-Scale");
        this.previewButton.setBorder(null);
        this.previewButton.setIcon(previewLandscapeDefaultIcon);
        this.gridCheckBox.setText("Grid");
        this.topLeftRadioButton.setActionCommand("Default");
        this.topLeftRadioButton.setText("Top Left");
        this.topLeftRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwtPrintDialog.this.defaultPosRadioButton_actionPerformed(e);
            }
        });
        this.centerRadioButton.setActionCommand("Center");
        this.centerRadioButton.setText("Center");
        this.centerRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwtPrintDialog.this.centerRadioButton_actionPerformed(e);
            }
        });
        this.portraitRadioButton.setActionCommand("Portrait");
        this.portraitRadioButton.setText("Portrait");
        this.portraitRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwtPrintDialog.this.portraitRadioButton_actionPerformed(e);
            }
        });
        this.fitToPageRadioButton.setActionCommand("Fit To Page");
        this.fitToPageRadioButton.setText("Fit to Page");
        this.fitToPageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwtPrintDialog.this.fitToPageRadioButton_actionPerformed(e);
            }
        });
        this.chooseFontRadioButton.setText("Choose font");
        this.defaultFontRadioButton.setText("Use default");
        this.titleCheckBox.setText("Title");
        this.getContentPane().add((Component)buttonPanel, "South");
        if (isJob) {
            buttonPanel.add((Component)this.printButton, null);
        }
        buttonPanel.add((Component)this.pdfButton, null);
        buttonPanel.add((Component)this.cancelButton, null);
        Insets insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)layoutContentPanel, "Center");
        layoutContentPanel.add((Component)layoutPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, insets, 0, 0));
        layoutPanel.add((Component)this.landscapeRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        layoutPanel.add((Component)this.portraitRadioButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        layoutPanel.add((Component)this.titleCheckBox, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        layoutPanel.add((Component)this.gridCheckBox, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        layoutPanel.add((Component)this.fitToPageRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        layoutPanel.add((Component)this.topLeftRadioButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        layoutPanel.add((Component)this.centerRadioButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        layoutPanel.add((Component)this.scaleXCheckBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        layoutPanel.add((Component)this.scaleYCheckBox, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        layoutPanel.add((Component)this.previewButton, new GridBagConstraints(2, 0, 1, 5, 0.0, 1.0, 18, 1, insets, 0, 0));
        layoutPanel.add(paperComboBox, new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.setDefaults();
    }

    void portraitRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    void landscapeRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    void centerRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    void fitToPageRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    private void setPreview() {
        int layout = " PL".indexOf(this.layoutButtonGroup.getSelection().getActionCommand().charAt(0));
        int position = " DCF".indexOf(this.positionButtonGroup.getSelection().getActionCommand().charAt(0));
        ImageIcon icon = null;
        switch ((layout << 4) + position) {
            default: {
                icon = previewPortraitDefaultIcon;
                break;
            }
            case 18: {
                icon = previewPortraitCenterIcon;
                break;
            }
            case 19: {
                icon = previewPortraitFitIcon;
                break;
            }
            case 33: {
                icon = previewLandscapeDefaultIcon;
                break;
            }
            case 34: {
                icon = previewLandscapeCenterIcon;
                break;
            }
            case 35: {
                icon = previewLandscapeFitIcon;
            }
        }
        this.previewButton.setIcon(icon);
    }

    void defaultPosRadioButton_actionPerformed(ActionEvent e) {
        this.setPreview();
    }

    private void setDefaults() {
        this.landscapeRadioButton.setSelected(this.pl.layout.equals("landscape"));
        this.portraitRadioButton.setSelected(!this.landscapeRadioButton.isSelected());
        this.scaleXCheckBox.setSelected(this.pl.showXScale);
        this.scaleYCheckBox.setSelected(this.pl.showYScale);
        this.gridCheckBox.setSelected(this.pl.showGrid);
        this.titleCheckBox.setSelected(this.pl.showTitle);
        this.fitToPageRadioButton.setSelected(this.pl.position.equals("fit to page"));
        this.centerRadioButton.setSelected(this.pl.position.equals("center"));
        this.topLeftRadioButton.setSelected(this.pl.position.equals("default"));
        this.defaultFontRadioButton.setSelected(this.pl.font == null);
        int i = 0;
        while (i < paperComboBox.getItemCount()) {
            if (this.pl.paper == null || paperComboBox.getItemAt(i).equals(this.pl.paper)) {
                paperComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.setPreview();
    }

    void printButton_actionPerformed(boolean asPDF) {
        this.plNew = new PrintLayout();
        this.plNew.layout = this.layoutButtonGroup.getSelection().getActionCommand().toLowerCase();
        this.plNew.font = null;
        this.plNew.position = this.positionButtonGroup.getSelection().getActionCommand().toLowerCase();
        this.plNew.showGrid = this.gridCheckBox.isSelected();
        this.plNew.showXScale = this.scaleXCheckBox.isSelected();
        this.plNew.showYScale = this.scaleYCheckBox.isSelected();
        this.plNew.showTitle = this.titleCheckBox.isSelected();
        this.plNew.paper = paperComboBox.getSelectedItem();
        this.plNew.asPDF = asPDF;
        this.dispose();
    }

    @Override
    public PrintLayout getPrintLayout() {
        return this.plNew;
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

