/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.type;

import groovy.lang.GroovyObjectSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.InvalidUserDataException;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.plugins.signing.type.SignatureTypeProvider;

public abstract class AbstractSignatureTypeProvider
extends GroovyObjectSupport
implements SignatureTypeProvider {
    private String defaultTypeExtension;
    private final Map<String, SignatureType> types = new LinkedHashMap<String, SignatureType>();

    public SignatureType getDefaultType() {
        return this.getTypeForExtension(this.defaultTypeExtension);
    }

    public void setDefaultType(String defaultTypeExtension) {
        this.assertHasTypeForExtension(defaultTypeExtension);
        this.defaultTypeExtension = defaultTypeExtension;
    }

    public boolean hasTypeForExtension(String extension) {
        return this.types.containsKey(extension);
    }

    public SignatureType getTypeForExtension(String extension) {
        this.assertHasTypeForExtension(extension);
        return this.types.get(extension);
    }

    protected void register(SignatureType type) {
        this.types.put(type.getExtension(), type);
    }

    private void assertHasTypeForExtension(String extension) {
        if (!this.hasTypeForExtension(extension)) {
            throw new InvalidUserDataException("no signature type is registered for extension '" + extension + "'");
        }
    }
}

