/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputFilesTaskStateChanges
extends AbstractFileSnapshotTaskStateChanges {
    private final TaskExecution previous;
    private final TaskExecution current;
    private final FileCollectionSnapshotter snapshotter;
    private final FileCollectionSnapshot.PreCheck inputFilesSnapshotPreCheck;
    private FileCollectionSnapshot inputFilesSnapshot;
    private final boolean noChanges;

    public InputFilesTaskStateChanges(TaskExecution previous, TaskExecution current, TaskInternal task, FileCollectionSnapshotter snapshotter) {
        super(task.getName());
        this.previous = previous;
        this.current = current;
        this.snapshotter = snapshotter;
        this.inputFilesSnapshotPreCheck = this.createSnapshotPreCheck(snapshotter, task.getInputs().getFiles());
        this.noChanges = previous != null && previous.getInputFilesHash() != null && previous.getInputFilesHash().equals(this.inputFilesSnapshotPreCheck.getHash());
    }

    @Override
    public FileCollectionSnapshot getPrevious() {
        return this.previous.getInputFilesSnapshot();
    }

    @Override
    public FileCollectionSnapshot getCurrent() {
        if (this.inputFilesSnapshot == null) {
            this.inputFilesSnapshot = this.createSnapshot(this.snapshotter, this.inputFilesSnapshotPreCheck);
        }
        return this.inputFilesSnapshot;
    }

    @Override
    public void saveCurrent() {
        this.current.setInputFilesHash(this.inputFilesSnapshotPreCheck.getHash());
        this.current.setInputFilesSnapshot(this.getCurrent());
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        if (this.noChanges) {
            return Iterators.emptyIterator();
        }
        return super.iterator();
    }

    @Override
    protected String getInputFileType() {
        return "Input";
    }
}

