/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskTypeTaskStateChanges
extends SimpleTaskStateChanges {
    private final String taskClass;
    private final TaskExecution previousExecution;
    private final TaskInternal task;

    public TaskTypeTaskStateChanges(TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task) {
        String taskClass = task.getClass().getName();
        currentExecution.setTaskClass(taskClass);
        this.taskClass = taskClass;
        this.previousExecution = previousExecution;
        this.task = task;
    }

    @Override
    protected void addAllChanges(List<TaskStateChange> changes) {
        if (!this.taskClass.equals(this.previousExecution.getTaskClass())) {
            changes.add(new DescriptiveChange("%s has changed type from '%s' to '%s'.", StringUtils.capitalize((String)this.task.toString()), this.previousExecution.getTaskClass(), this.task.getClass().getName()));
        }
    }
}

