/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.SettingsHandler;
import org.gradle.initialization.SettingsLoader;

public class NotifyingSettingsLoader
implements SettingsLoader {
    private final SettingsHandler settingsHandler;
    private final BuildLoader buildLoader;

    public NotifyingSettingsLoader(SettingsHandler settingsHandler, BuildLoader buildLoader) {
        this.settingsHandler = settingsHandler;
        this.buildLoader = buildLoader;
    }

    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings = this.settingsHandler.findAndLoadSettings(gradle);
        gradle.getBuildListenerBroadcaster().settingsEvaluated(settings);
        this.buildLoader.load(settings.getRootProject(), settings.getDefaultProject(), gradle, settings.getRootClassLoaderScope());
        gradle.getBuildListenerBroadcaster().projectsLoaded(gradle);
        return settings;
    }
}

