/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.internal.exceptions.Contextual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelPath
implements Iterable<String>,
Comparable<ModelPath> {
    private static final String SEPARATOR = ".";
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'.').omitEmptyStrings();
    private static final Joiner PATH_JOINER = Joiner.on((char)'.');
    private static final CharMatcher VALID_FIRST_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_'));
    private static final CharMatcher INVALID_FIRST_CHAR_MATCHER = VALID_FIRST_CHAR_MATCHER.negate().precomputed();
    private static final CharMatcher INVALID_CHAR_MATCHER = CharMatcher.inRange((char)'0', (char)'9').or(VALID_FIRST_CHAR_MATCHER).or(CharMatcher.is((char)'-')).negate().precomputed();
    public static final ModelPath ROOT = new ModelPath(""){

        public String toString() {
            return "<root>";
        }

        public ModelPath descendant(ModelPath path) {
            return path;
        }
    };
    private static final Cache BY_PATH = new Cache(ROOT);
    private final String path;
    private final List<String> components;
    private final ModelPath parent;

    public ModelPath(String path) {
        this.path = path;
        this.components = new ArrayList<String>(PATH_SPLITTER.splitToList((CharSequence)path));
        this.parent = this.doGetParent();
    }

    private ModelPath(String path, Iterable<String> components) {
        this.path = path;
        this.components = Lists.newArrayList(components);
        this.parent = this.doGetParent();
    }

    @Override
    public int compareTo(ModelPath other) {
        if (this == other) {
            return 0;
        }
        return this.path.compareTo(other.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelPath modelPath = (ModelPath)o;
        return this.components.size() == modelPath.components.size() && this.path.equals(modelPath.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public int getDepth() {
        return this.components.size();
    }

    public List<String> getComponents() {
        return this.components;
    }

    @Override
    public Iterator<String> iterator() {
        return this.components.iterator();
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.path;
    }

    public static ModelPath path(String path) {
        return BY_PATH.get(path);
    }

    public static ModelPath path(Iterable<String> names) {
        String path = ModelPath.pathString(names);
        for (String name : names) {
            if (name.indexOf(46) < 0) continue;
            return new ModelPath(path, names);
        }
        return BY_PATH.get(path);
    }

    public static String pathString(Iterable<String> names) {
        return PATH_JOINER.join(names);
    }

    public ModelPath child(String child) {
        ArrayList<String> childComponents = new ArrayList<String>(this.components);
        childComponents.add(child);
        return ModelPath.path(childComponents);
    }

    public ModelPath getRootParent() {
        return this.components.size() <= 1 ? null : ModelPath.path(this.components.get(0));
    }

    @Nullable
    public ModelPath getParent() {
        return this.parent;
    }

    private ModelPath doGetParent() {
        if (this.components.isEmpty()) {
            return null;
        }
        if (this.components.size() == 1) {
            return ROOT;
        }
        String parentPath = this.path.substring(0, this.path.length() - this.components.get(this.components.size() - 1).length() - 1);
        return BY_PATH.get(parentPath);
    }

    public String getName() {
        if (this.components.isEmpty()) {
            return "";
        }
        return this.components.get(this.components.size() - 1);
    }

    public boolean isDirectChild(@Nullable ModelPath other) {
        if (other == null) {
            return false;
        }
        if (other.getDepth() != this.getDepth() + 1) {
            return false;
        }
        ModelPath otherParent = other.getParent();
        return otherParent != null && otherParent.equals(this);
    }

    public boolean isDescendant(@Nullable ModelPath other) {
        if (other == null) {
            return false;
        }
        if (other.getDepth() <= this.getDepth()) {
            return false;
        }
        return this.getComponents().equals(other.getComponents().subList(0, this.getDepth()));
    }

    public ModelPath descendant(ModelPath path) {
        return ModelPath.path(Iterables.concat(this.components, path.components));
    }

    public static void validateName(String name) {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot use an empty string as a model element name.");
        }
        char firstChar = name.charAt(0);
        if (INVALID_FIRST_CHAR_MATCHER.matches(firstChar)) {
            throw new InvalidNameException(String.format("Model element name '%s' has illegal first character '%s' (names must start with an ASCII letter or underscore).", name, Character.valueOf(firstChar)));
        }
        for (int i = 1; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (!INVALID_CHAR_MATCHER.matches(character)) continue;
            throw new InvalidNameException(String.format("Model element name '%s' contains illegal character '%s' (only ASCII letters, numbers and the underscore are allowed).", name, Character.valueOf(character)));
        }
    }

    @Nullable
    public static ModelPath validatedPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        ModelPath.validatePath(path);
        return ModelPath.path(path);
    }

    public static ModelPath nonNullValidatedPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        return ModelPath.validatedPath(path);
    }

    public static void validatePath(String path) throws InvalidPathException {
        if (path.isEmpty()) {
            throw new InvalidPathException("Cannot use an empty string as a model path.", null);
        }
        if (path.startsWith(SEPARATOR)) {
            throw new InvalidPathException(String.format("Model path '%s' cannot start with name separator '%s'.", path, SEPARATOR), null);
        }
        if (path.endsWith(SEPARATOR)) {
            throw new InvalidPathException(String.format("Model path '%s' cannot end with name separator '%s'.", path, SEPARATOR), null);
        }
        List names = PATH_SPLITTER.splitToList((CharSequence)path);
        if (names.size() == 1) {
            ModelPath.validateName((String)names.get(0));
        } else {
            for (String name : names) {
                try {
                    ModelPath.validateName(name);
                }
                catch (InvalidNameException e) {
                    throw new InvalidPathException(String.format("Model path '%s' is invalid due to invalid name component.", path), e);
                }
            }
        }
    }

    private static class Cache {
        private final WeakHashMap<String, ModelPath> cache = new WeakHashMap();

        public Cache(ModelPath root) {
            this.cache.put(root.path, root);
        }

        public synchronized ModelPath get(String path) {
            ModelPath result = this.cache.get(path);
            if (result != null) {
                return result;
            }
            result = new ModelPath(path);
            this.cache.put(path, result);
            return result;
        }
    }

    @Contextual
    public static class InvalidPathException
    extends GradleException {
        public InvalidPathException(String message, InvalidNameException e) {
            super(message, (Throwable)((Object)e));
        }
    }

    public static class InvalidNameException
    extends GradleException {
        public InvalidNameException(String message) {
            super(message);
        }
    }
}

