/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging;

import com.sun.javafx.logging.LoggingProxy;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;

class LoggingSupport {
    private static final LoggingProxy proxy = AccessController.doPrivileged(new PrivilegedAction<LoggingProxy>(){

        @Override
        public LoggingProxy run() {
            try {
                Class<?> clazz = Class.forName("java.util.logging.LoggingProxyImpl", true, null);
                Field field = clazz.getDeclaredField("INSTANCE");
                field.setAccessible(true);
                return (LoggingProxy)field.get(null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError((Object)noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }
    });

    private LoggingSupport() {
    }

    static boolean isAvailable() {
        return proxy != null;
    }

    static void ensureAvailable() {
        if (proxy == null) {
            throw new AssertionError((Object)"Should not here");
        }
    }

    static List<String> getLoggerNames() {
        LoggingSupport.ensureAvailable();
        return proxy.getLoggerNames();
    }

    static String getLoggerLevel(String string) {
        LoggingSupport.ensureAvailable();
        return proxy.getLoggerLevel(string);
    }

    static void setLoggerLevel(String string, String string2) {
        LoggingSupport.ensureAvailable();
        proxy.setLoggerLevel(string, string2);
    }

    static String getParentLoggerName(String string) {
        LoggingSupport.ensureAvailable();
        return proxy.getParentLoggerName(string);
    }

    static Object getLogger(String string) {
        LoggingSupport.ensureAvailable();
        return proxy.getLogger(string);
    }

    static Object getLevel(Object object) {
        LoggingSupport.ensureAvailable();
        return proxy.getLevel(object);
    }

    static void setLevel(Object object, Object object2) {
        LoggingSupport.ensureAvailable();
        proxy.setLevel(object, object2);
    }

    static boolean isLoggable(Object object, Object object2) {
        LoggingSupport.ensureAvailable();
        return proxy.isLoggable(object, object2);
    }

    static void log(Object object, Object object2, String string) {
        LoggingSupport.ensureAvailable();
        proxy.log(object, object2, string);
    }

    static void log(Object object, Object object2, String string, Throwable throwable) {
        LoggingSupport.ensureAvailable();
        proxy.log(object, object2, string, throwable);
    }

    static void log(Object object, Object object2, String string, Object ... objectArray) {
        LoggingSupport.ensureAvailable();
        proxy.log(object, object2, string, objectArray);
    }

    static Object parseLevel(String string) {
        LoggingSupport.ensureAvailable();
        return proxy.parseLevel(string);
    }

    static String getLevelName(Object object) {
        LoggingSupport.ensureAvailable();
        return proxy.getLevelName(object);
    }
}

