/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.announce.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.plugins.announce.Announcer;
import org.gradle.api.plugins.announce.internal.AnnouncerUnavailableException;
import org.gradle.api.plugins.announce.internal.IconProvider;
import org.gradle.internal.UncheckedException;
import org.gradle.util.CollectionUtils;

public class Snarl
implements Announcer {
    private static final float SNP_VERSION = 1.1f;
    private static final String HEAD = "type=SNP#?version=1.1";
    private final IconProvider iconProvider;

    public Snarl(IconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    public void send(String title, String message) {
        try {
            this.send(InetAddress.getByName(null), title, message);
        }
        catch (UnknownHostException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void send(InetAddress host, String title, String message) {
        Socket socket = null;
        try {
            try {
                socket = new Socket(host, 9887);
            }
            catch (ConnectException e) {
                throw new AnnouncerUnavailableException("Snarl is not running on host " + String.valueOf(host) + ".", e);
            }
            PrintWriter printWriter = null;
            try {
                OutputStream outputStream = socket.getOutputStream();
                printWriter = new PrintWriter(outputStream, true);
                printWriter.println(this.formatMessage(title, message));
            }
            catch (IOException e) {
                try {
                    throw new UncheckedIOException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(printWriter);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)printWriter);
        }
        catch (IOException ioException) {
            try {
                throw new UncheckedIOException((Throwable)ioException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(socket);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Socket)socket);
    }

    private String formatMessage(String title, String message) {
        File icon = this.iconProvider.getIcon(32, 32);
        List<String> properties = Arrays.asList(Snarl.formatProperty("action", "notification"), Snarl.formatProperty("app", "Gradle Snarl Notifier"), Snarl.formatProperty("class", "alert"), Snarl.formatProperty("title", title), Snarl.formatProperty("text", message), Snarl.formatProperty("icon", icon == null ? null : icon.getAbsolutePath()), Snarl.formatProperty("timeout", "10"));
        return HEAD + CollectionUtils.join((String)"", properties) + "\r\n";
    }

    private static String formatProperty(String name, String value) {
        if (value != null && !value.isEmpty()) {
            return "#?" + name + "=" + value;
        }
        return "";
    }
}

