/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.gradle.api.internal.tasks.testing.processors.DefaultStandardOutputRedirector;
import org.gradle.internal.logging.StandardOutputCapture;
import org.gradle.util.SingleMessageLogger;

public class JULRedirector
extends DefaultStandardOutputRedirector {
    @VisibleForTesting
    public static final String READ_LOGGING_CONFIG_FILE_PROPERTY = "org.gradle.readLoggingConfigFile";
    private boolean reset;

    public StandardOutputCapture start() {
        super.start();
        boolean shouldReadLoggingConfigFile = System.getProperty(READ_LOGGING_CONFIG_FILE_PROPERTY, "true").equals("true");
        if (!shouldReadLoggingConfigFile) {
            SingleMessageLogger.nagUserOfDiscontinuedProperty((String)READ_LOGGING_CONFIG_FILE_PROPERTY, (String)"Change your test to work with your java.util.logging configuration file settings.");
        }
        if (!this.reset) {
            LogManager.getLogManager().reset();
            if (shouldReadLoggingConfigFile) {
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (IOException error) {
                    Logger.getLogger("").addHandler(new ConsoleHandler());
                }
            } else {
                Logger.getLogger("").addHandler(new ConsoleHandler());
            }
            this.reset = true;
        }
        return this;
    }
}

