/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.local.LocalResource;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;

public class SftpResourceUploader
implements ExternalResourceUploader {
    private final SftpClientFactory sftpClientFactory;
    private final PasswordCredentials credentials;

    public SftpResourceUploader(SftpClientFactory sftpClientFactory, PasswordCredentials credentials) {
        this.sftpClientFactory = sftpClientFactory;
        this.credentials = credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(LocalResource resource, URI destination) throws IOException {
        LockableSftpClient client = this.sftpClientFactory.createSftpClient(destination, this.credentials);
        try {
            ChannelSftp channel = client.getSftpClient();
            this.ensureParentDirectoryExists(channel, destination);
            InputStream sourceStream = resource.open();
            try {
                channel.put(sourceStream, destination.getPath());
            }
            finally {
                sourceStream.close();
            }
        }
        catch (SftpException e) {
            throw ResourceExceptions.putFailed((URI)destination, (Throwable)e);
        }
        finally {
            this.sftpClientFactory.releaseSftpClient(client);
        }
    }

    private void ensureParentDirectoryExists(ChannelSftp channel, URI uri) {
        String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)uri.getPath());
        if (parentPath.equals("/")) {
            return;
        }
        URI parent = uri.resolve(parentPath);
        try {
            channel.lstat(parentPath);
            return;
        }
        catch (SftpException e) {
            if (e.id != 2) {
                throw new ResourceException(parent, String.format("Could not lstat resource '%s'.", parent), (Throwable)e);
            }
            this.ensureParentDirectoryExists(channel, parent);
            try {
                channel.mkdir(parentPath);
            }
            catch (SftpException e2) {
                throw new ResourceException(parent, String.format("Could not create resource '%s'.", parent), (Throwable)e2);
            }
            return;
        }
    }
}

