/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.MessagingClient;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddressSerializer;
import org.gradle.internal.remote.services.MessagingServices;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.process.internal.worker.child.WorkerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemApplicationClassLoaderWorker
implements Callable<Void> {
    private final DataInputStream configInputStream;

    public SystemApplicationClassLoaderWorker(DataInputStream configInputStream) {
        this.configInputStream = configInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        if (System.getProperty("org.gradle.worker.test.stuck") != null) {
            Thread.sleep(30000L);
            return null;
        }
        InputStreamBackedDecoder decoder = new InputStreamBackedDecoder((InputStream)this.configInputStream);
        int logLevel = decoder.readSmallInt();
        LoggingManagerInternal loggingManager = this.createLoggingManager();
        loggingManager.setLevelInternal(LogLevel.values()[logLevel]).start();
        MultiChoiceAddress serverAddress = new MultiChoiceAddressSerializer().read((Decoder)decoder);
        MessagingServices messagingServices = this.createClient();
        try {
            final ObjectConnection connection = ((MessagingClient)messagingServices.get(MessagingClient.class)).getConnection((Address)serverAddress);
            try {
                Action action;
                byte[] serializedWorker = decoder.readBinary();
                try {
                    ClassLoaderObjectInputStream instr = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedWorker), this.getClass().getClassLoader());
                    action = (Action)instr.readObject();
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                action.execute((Object)new WorkerContext(){

                    public ClassLoader getApplicationClassLoader() {
                        return ClassLoader.getSystemClassLoader();
                    }

                    public ObjectConnection getServerConnection() {
                        return connection;
                    }
                });
            }
            finally {
                connection.stop();
            }
        }
        finally {
            messagingServices.close();
        }
        return null;
    }

    MessagingServices createClient() {
        return new MessagingServices();
    }

    LoggingManagerInternal createLoggingManager() {
        return (LoggingManagerInternal)LoggingServiceRegistry.newCommandLineProcessLogging().newInstance(LoggingManagerInternal.class);
    }
}

