/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ArchiveEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileToArchiveEntrySetTransformer
implements Transformer<Set<ArchiveEntry>, File> {
    public Set<ArchiveEntry> transform(File archiveFile) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(archiveFile);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        ImmutableSet.Builder allEntries = ImmutableSet.builder();
        this.walk(fileInputStream, (ImmutableSet.Builder<ArchiveEntry>)allEntries, (ImmutableList<String>)ImmutableList.of());
        return allEntries.build();
    }

    private ImmutableSet<ArchiveEntry> walk(InputStream archiveInputStream, ImmutableSet.Builder<ArchiveEntry> allEntries, ImmutableList<String> parentPaths) {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        ZipInputStream zipStream = new ZipInputStream(archiveInputStream);
        try {
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                ArchiveEntry.Builder builder = new ArchiveEntry.Builder();
                builder.setParentPaths((List<String>)parentPaths);
                builder.setPath(entry.getName());
                builder.setCrc(entry.getCrc());
                builder.setDirectory(entry.isDirectory());
                builder.setSize(entry.getSize());
                if (!builder.isDirectory() && zipStream.available() == 1) {
                    BufferedInputStream bis = new BufferedInputStream(zipStream){

                        public void close() throws IOException {
                        }
                    };
                    bis.mark(Integer.MAX_VALUE);
                    boolean zipEntry = new ZipInputStream(bis).getNextEntry() != null;
                    bis.reset();
                    if (zipEntry) {
                        ImmutableList nextParentPaths = ImmutableList.builder().addAll(parentPaths).add((Object)entry.getName()).build();
                        ImmutableSet<ArchiveEntry> subEntries = this.walk(bis, allEntries, (ImmutableList<String>)nextParentPaths);
                        builder.setSubEntries(subEntries);
                    }
                }
                ArchiveEntry archiveEntry = builder.build();
                entries.add((Object)archiveEntry);
                allEntries.add((Object)archiveEntry);
                zipStream.closeEntry();
                entry = zipStream.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipStream);
        }
        return entries.build();
    }
}

