/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;

public class DefaultOperatingSystem
implements OperatingSystemInternal {
    private static final OperatingSystem CURRENT_OS = OperatingSystem.current();
    private final String name;
    private final OperatingSystem internalOs;

    public DefaultOperatingSystem(String name) {
        this(name, OperatingSystem.forName((String)name));
    }

    public DefaultOperatingSystem(String name, OperatingSystem internalOs) {
        this.name = name;
        this.internalOs = internalOs;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return "operating system '" + this.name + "'";
    }

    public String toString() {
        return this.getDisplayName();
    }

    public OperatingSystem getInternalOs() {
        return this.internalOs;
    }

    public boolean isCurrent() {
        return this.internalOs == CURRENT_OS;
    }

    public boolean isWindows() {
        return this.internalOs.isWindows();
    }

    public boolean isLinux() {
        return this.internalOs.isLinux();
    }

    public boolean isMacOsX() {
        return this.internalOs.isMacOsX();
    }

    public boolean isSolaris() {
        return this.internalOs == OperatingSystem.SOLARIS;
    }

    public boolean isFreeBSD() {
        return this.internalOs == OperatingSystem.FREE_BSD;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOperatingSystem that = (DefaultOperatingSystem)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

