/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Preconditions;
import groovy.util.Node;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.util.DeprecationLogger;

public class ProjectDependency
extends AbstractClasspathEntry {
    private static final String DEPRECATED_DECLAREDCONFIGNAME_FIELD = "ProjectDependency.declaredConfigurationName";
    private String gradlePath;
    private String declaredConfigurationName;

    public ProjectDependency(Node node) {
        super(node);
        this.assertPathIsValid();
    }

    public ProjectDependency(String path, String gradlePath) {
        super(path);
        this.assertPathIsValid();
        this.gradlePath = gradlePath;
    }

    public String getGradlePath() {
        return this.gradlePath;
    }

    public void setGradlePath(String gradlePath) {
        this.gradlePath = gradlePath;
    }

    @Deprecated
    public String getDeclaredConfigurationName() {
        DeprecationLogger.nagUserOfDeprecated((String)DEPRECATED_DECLAREDCONFIGNAME_FIELD);
        return this.declaredConfigurationName;
    }

    public void setDeclaredConfigurationName(String declaredConfigurationName) {
        DeprecationLogger.nagUserOfDeprecated((String)DEPRECATED_DECLAREDCONFIGNAME_FIELD);
        this.declaredConfigurationName = declaredConfigurationName;
    }

    private void assertPathIsValid() {
        Preconditions.checkArgument((boolean)this.path.startsWith("/"));
    }

    public String getKind() {
        return "src";
    }

    public String toString() {
        return "ProjectDependency" + super.toString();
    }
}

