/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.ivy.plugins.repository.LocalizableResource;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class URLResource
implements LocalizableResource {
    private URL url;
    private boolean init = false;
    private long lastModified;
    private long contentLength;
    private boolean exists;

    public URLResource(URL url) {
        this.url = url;
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    public Resource clone(String cloneName) {
        try {
            return new URLResource(new URL(cloneName));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("bad clone name provided: not suitable for an URLResource: " + cloneName);
        }
    }

    public long getLastModified() {
        if (!this.init) {
            this.init();
        }
        return this.lastModified;
    }

    private void init() {
        URLHandler.URLInfo info = URLHandlerRegistry.getDefault().getURLInfo(this.url);
        this.contentLength = info.getContentLength();
        this.lastModified = info.getLastModified();
        this.exists = info.isReachable();
        this.init = true;
    }

    public long getContentLength() {
        if (!this.init) {
            this.init();
        }
        return this.contentLength;
    }

    public boolean exists() {
        if (!this.init) {
            this.init();
        }
        return this.exists;
    }

    public URL getURL() {
        return this.url;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isLocal() {
        return this.url.getProtocol().equals("file");
    }

    public InputStream openStream() throws IOException {
        return URLHandlerRegistry.getDefault().openStream(this.url);
    }

    public File getFile() {
        if (!this.isLocal()) {
            throw new IllegalStateException("Cannot get the local file for the not local resource " + this.url);
        }
        try {
            return new File(this.url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(this.url.getPath());
        }
    }
}

