/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.repository.internal;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.plugin.repository.internal.BackedByArtifactRepository;
import org.gradle.plugin.repository.internal.PluginRepositoryInternal;
import org.gradle.plugin.use.resolve.internal.ArtifactRepositoryPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPluginRepository
implements AuthenticationSupported,
PluginRepositoryInternal,
BackedByArtifactRepository {
    private static final String REPOSITORY_PREFIX = "__pluginRepository__";
    private final FileResolver fileResolver;
    private final DependencyResolutionServices dependencyResolutionServices;
    private final VersionSelectorScheme versionSelectorScheme;
    private final AuthenticationSupportedInternal authenticationSupport;
    private final AtomicBoolean hasYieldedArtifactRepository;
    private String name;
    private Object url;
    private PluginResolver resolver;

    AbstractPluginRepository(String defaultName, FileResolver fileResolver, DependencyResolutionServices dependencyResolutionServices, VersionSelectorScheme versionSelectorScheme, AuthenticationSupportedInternal authenticationSupport) {
        this.authenticationSupport = authenticationSupport;
        this.fileResolver = fileResolver;
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.versionSelectorScheme = versionSelectorScheme;
        this.name = defaultName;
        this.hasYieldedArtifactRepository = new AtomicBoolean(false);
    }

    AuthenticationSupportedInternal authenticationSupport() {
        return this.authenticationSupport;
    }

    String getArtifactRepositoryName() {
        return REPOSITORY_PREFIX + this.name;
    }

    protected abstract ArtifactRepository internalCreateArtifactRepository(RepositoryHandler var1);

    @Override
    public ArtifactRepository createArtifactRepository(RepositoryHandler repositoryHandler) {
        ArtifactRepository repo = this.internalCreateArtifactRepository(repositoryHandler);
        this.hasYieldedArtifactRepository.set(true);
        return repo;
    }

    public URI getUrl() {
        return this.fileResolver.resolveUri(this.url);
    }

    public void setUrl(Object url) {
        this.checkMutable();
        this.url = url;
    }

    public PasswordCredentials getCredentials() {
        return this.authenticationSupport.getCredentials();
    }

    public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
        return (T)this.authenticationSupport.getCredentials(credentialsType);
    }

    public void credentials(Action<? super PasswordCredentials> action) {
        this.checkMutable();
        this.authenticationSupport.credentials(action);
    }

    public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) {
        this.checkMutable();
        this.authenticationSupport.credentials(credentialsType, action);
    }

    public void authentication(Action<? super AuthenticationContainer> action) {
        this.checkMutable();
        this.authenticationSupport.authentication(action);
    }

    public AuthenticationContainer getAuthentication() {
        return this.authenticationSupport.getAuthentication();
    }

    @Override
    public PluginResolver asResolver() {
        if (this.resolver == null) {
            this.createArtifactRepository(this.dependencyResolutionServices.getResolveRepositoryHandler());
            this.resolver = new ArtifactRepositoryPluginResolver(this.name + '(' + this.url + ')', this.dependencyResolutionServices, this.versionSelectorScheme);
        }
        return this.resolver;
    }

    private void checkMutable() {
        if (this.hasYieldedArtifactRepository.get()) {
            throw new IllegalStateException("A plugin repository cannot be modified after it has been used to resolve plugins.");
        }
    }
}

