/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.api.Transformer;
import org.gradle.internal.FileUtils;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.platform.Architecture;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.ArchitectureDescriptor;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioLocator;
import org.gradle.util.CollectionUtils;
import org.gradle.util.TreeVisitor;
import org.gradle.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVisualStudioLocator
implements VisualStudioLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultVisualStudioLocator.class);
    private static final String[] REGISTRY_BASEPATHS = new String[]{"SOFTWARE\\", "SOFTWARE\\Wow6432Node\\"};
    private static final String REGISTRY_ROOTPATH_VC = "Microsoft\\VisualStudio\\SxS\\VC7";
    private static final String PATH_COMMON = "Common7/";
    private static final String PATH_COMMONTOOLS = "Common7/Tools/";
    private static final String PATH_COMMONIDE = "Common7/IDE/";
    private static final String PATH_BIN = "bin/";
    private static final String PATH_INCLUDE = "include/";
    private static final String COMPILER_FILENAME = "cl.exe";
    private static final String DEFINE_ARMPARTITIONAVAILABLE = "_ARM_WINAPI_PARTITION_DESKTOP_SDK_AVAILABLE";
    private final Map<File, VisualStudioInstall> foundInstalls = new HashMap<File, VisualStudioInstall>();
    private final OperatingSystem os;
    private final WindowsRegistry windowsRegistry;
    private final SystemInfo systemInfo;
    private VisualStudioInstall pathInstall;
    private boolean initialised;

    public DefaultVisualStudioLocator(OperatingSystem os, WindowsRegistry windowsRegistry, SystemInfo systemInfo) {
        this.os = os;
        this.windowsRegistry = windowsRegistry;
        this.systemInfo = systemInfo;
    }

    @Override
    public List<VisualStudioLocator.SearchResult> locateAllVisualStudioVersions() {
        this.initializeVisualStudioInstalls();
        List sortedInstalls = CollectionUtils.sort(this.foundInstalls.values(), (Comparator)new Comparator<VisualStudioInstall>(){

            @Override
            public int compare(VisualStudioInstall o1, VisualStudioInstall o2) {
                return o2.getVersion().compareTo(o1.getVersion());
            }
        });
        if (sortedInstalls.isEmpty()) {
            return Lists.newArrayList((Object[])new VisualStudioLocator.SearchResult[]{new InstallNotFound("Could not locate a Visual Studio installation, using the Windows registry and system path.")});
        }
        return CollectionUtils.collect((List)sortedInstalls, (Transformer)new Transformer<VisualStudioLocator.SearchResult, VisualStudioInstall>(){

            public VisualStudioLocator.SearchResult transform(VisualStudioInstall visualStudioInstall) {
                return new InstallFound(visualStudioInstall);
            }
        });
    }

    @Override
    public VisualStudioLocator.SearchResult locateDefaultVisualStudioInstall() {
        return this.locateDefaultVisualStudioInstall(null);
    }

    @Override
    public VisualStudioLocator.SearchResult locateDefaultVisualStudioInstall(File candidate) {
        this.initializeVisualStudioInstalls();
        if (candidate != null) {
            return this.locateUserSpecifiedInstall(candidate);
        }
        return this.determineDefaultInstall();
    }

    private void initializeVisualStudioInstalls() {
        if (!this.initialised) {
            this.locateInstallsInRegistry();
            this.locateInstallInPath();
            this.initialised = true;
        }
    }

    private void locateInstallsInRegistry() {
        for (String baseKey : REGISTRY_BASEPATHS) {
            this.locateInstallsInRegistry(baseKey);
        }
    }

    private void locateInstallsInRegistry(String baseKey) {
        List visualCppVersions;
        try {
            visualCppVersions = this.windowsRegistry.getValueNames(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_VC);
        }
        catch (MissingRegistryEntryException e) {
            return;
        }
        for (String valueName : visualCppVersions) {
            if (!valueName.matches("\\d+\\.\\d+")) continue;
            File visualCppDir = new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_VC, valueName));
            visualCppDir = FileUtils.canonicalize((File)visualCppDir);
            File visualStudioDir = visualCppDir.getParentFile();
            if (DefaultVisualStudioLocator.isVisualCpp(visualCppDir) && DefaultVisualStudioLocator.isVisualStudio(visualStudioDir)) {
                LOGGER.debug("Found Visual C++ {} at {}", (Object)valueName, (Object)visualCppDir);
                VersionNumber version = VersionNumber.parse((String)valueName);
                VisualCppInstall visualCpp = this.buildVisualCppInstall("Visual C++ " + valueName, visualStudioDir, visualCppDir, version);
                VisualStudioInstall visualStudio = new VisualStudioInstall(visualStudioDir, visualCpp);
                this.foundInstalls.put(visualStudioDir, visualStudio);
                continue;
            }
            LOGGER.debug("Ignoring candidate Visual C++ directory {} as it does not look like a Visual C++ installation.", (Object)visualCppDir);
        }
    }

    private void locateInstallInPath() {
        File compilerInPath = this.os.findInPath(COMPILER_FILENAME);
        if (compilerInPath == null) {
            LOGGER.debug("No visual c++ compiler found in system path.");
            return;
        }
        File visualCppDir = FileUtils.canonicalize((File)compilerInPath.getParentFile().getParentFile());
        if (!DefaultVisualStudioLocator.isVisualCpp(visualCppDir) && !DefaultVisualStudioLocator.isVisualCpp(visualCppDir = visualCppDir.getParentFile())) {
            LOGGER.debug("Ignoring candidate Visual C++ install for {} as it does not look like a Visual C++ installation.", (Object)compilerInPath);
            return;
        }
        LOGGER.debug("Found Visual C++ install {} using system path", (Object)visualCppDir);
        File visualStudioDir = visualCppDir.getParentFile();
        if (!this.foundInstalls.containsKey(visualStudioDir)) {
            VisualCppInstall visualCpp = this.buildVisualCppInstall("Visual C++ from system path", visualStudioDir, visualCppDir, VersionNumber.UNKNOWN);
            VisualStudioInstall visualStudio = new VisualStudioInstall(visualStudioDir, visualCpp);
            this.foundInstalls.put(visualStudioDir, visualStudio);
        }
        this.pathInstall = this.foundInstalls.get(visualStudioDir);
    }

    private VisualStudioLocator.SearchResult locateUserSpecifiedInstall(File candidate) {
        File visualStudioDir = FileUtils.canonicalize((File)candidate);
        File visualCppDir = new File(visualStudioDir, "VC");
        if (!DefaultVisualStudioLocator.isVisualStudio(visualStudioDir) || !DefaultVisualStudioLocator.isVisualCpp(visualCppDir)) {
            LOGGER.debug("Ignoring candidate Visual C++ install for {} as it does not look like a Visual C++ installation.", (Object)candidate);
            return new InstallNotFound(String.format("The specified installation directory '%s' does not appear to contain a Visual Studio installation.", candidate));
        }
        if (!this.foundInstalls.containsKey(visualStudioDir)) {
            VisualCppInstall visualCpp = this.buildVisualCppInstall("Visual C++ from user provided path", visualStudioDir, visualCppDir, VersionNumber.UNKNOWN);
            VisualStudioInstall visualStudio = new VisualStudioInstall(visualStudioDir, visualCpp);
            this.foundInstalls.put(visualStudioDir, visualStudio);
        }
        return new InstallFound(this.foundInstalls.get(visualStudioDir));
    }

    private VisualCppInstall buildVisualCppInstall(String name, File vsPath, File basePath, VersionNumber version) {
        boolean isNativeAmd64;
        ArrayList architectureDescriptorBuilders = Lists.newArrayList();
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.X86_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.AMD64_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.IA64_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.ARM_ON_X86);
        boolean bl = isNativeAmd64 = this.systemInfo.getArchitecture() == SystemInfo.Architecture.amd64;
        if (isNativeAmd64) {
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.AMD64_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.X86_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.ARM_ON_AMD64);
        }
        HashMap descriptors = Maps.newHashMap();
        for (ArchitectureDescriptorBuilder architectureDescriptorBuilder : architectureDescriptorBuilders) {
            ArchitectureDescriptor descriptor = architectureDescriptorBuilder.buildDescriptor(basePath, vsPath);
            if (!descriptor.isInstalled()) continue;
            descriptors.put(architectureDescriptorBuilder.architecture, descriptor);
        }
        return new VisualCppInstall(name, version, descriptors);
    }

    private VisualStudioLocator.SearchResult determineDefaultInstall() {
        if (this.pathInstall != null) {
            return new InstallFound(this.pathInstall);
        }
        VisualStudioInstall candidate = null;
        for (VisualStudioInstall visualStudio : this.foundInstalls.values()) {
            if (candidate != null && visualStudio.getVersion().compareTo(candidate.getVersion()) <= 0) continue;
            candidate = visualStudio;
        }
        return candidate == null ? new InstallNotFound("Could not locate a Visual Studio installation, using the Windows registry and system path.") : new InstallFound(candidate);
    }

    private static boolean isVisualStudio(File candidate) {
        return new File(candidate, PATH_COMMON).isDirectory() && DefaultVisualStudioLocator.isVisualCpp(new File(candidate, "VC"));
    }

    private static boolean isVisualCpp(File candidate) {
        return new File(candidate, "bin/cl.exe").isFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ArchitectureDescriptorBuilder {
        AMD64_ON_AMD64("amd64", "bin/amd64", "lib/amd64", "ml64.exe"),
        AMD64_ON_X86("amd64", "bin/x86_amd64", "lib/amd64", "ml64.exe"){

            File getCrossCompilePath(File basePath) {
                return X86_ON_X86.getBinPath(basePath);
            }
        }
        ,
        X86_ON_AMD64("x86", "bin/amd64_x86", "lib", "ml.exe"){

            File getCrossCompilePath(File basePath) {
                return AMD64_ON_AMD64.getBinPath(basePath);
            }
        }
        ,
        X86_ON_X86("x86", "bin", "lib", "ml.exe"),
        ARM_ON_AMD64("arm", "bin/amd64_arm", "lib/arm", "armasm.exe"){

            @Override
            File getCrossCompilePath(File basePath) {
                return AMD64_ON_AMD64.getBinPath(basePath);
            }

            @Override
            Map<String, String> getDefinitions() {
                Map<String, String> definitions = super.getDefinitions();
                definitions.put(DefaultVisualStudioLocator.DEFINE_ARMPARTITIONAVAILABLE, "1");
                return definitions;
            }
        }
        ,
        ARM_ON_X86("arm", "bin/x86_arm", "lib/arm", "armasm.exe"){

            @Override
            File getCrossCompilePath(File basePath) {
                return X86_ON_X86.getBinPath(basePath);
            }

            @Override
            Map<String, String> getDefinitions() {
                Map<String, String> definitions = super.getDefinitions();
                definitions.put(DefaultVisualStudioLocator.DEFINE_ARMPARTITIONAVAILABLE, "1");
                return definitions;
            }
        }
        ,
        IA64_ON_X86("ia64", "bin/x86_ia64", "lib/ia64", "ias.exe"){

            File getCrossCompilePath(File basePath) {
                return X86_ON_X86.getBinPath(basePath);
            }
        };

        final Architecture architecture;
        final String binPath;
        final String libPath;
        final String asmFilename;

        private ArchitectureDescriptorBuilder(String architecture, String binPath, String libPath, String asmFilename) {
            this.binPath = binPath;
            this.libPath = libPath;
            this.asmFilename = asmFilename;
            this.architecture = Architectures.forInput(architecture);
        }

        File getBinPath(File basePath) {
            return new File(basePath, this.binPath);
        }

        File getLibPath(File basePath) {
            return new File(basePath, this.libPath);
        }

        File getCompilerPath(File basePath) {
            return new File(this.getBinPath(basePath), DefaultVisualStudioLocator.COMPILER_FILENAME);
        }

        File getCrossCompilePath(File basePath) {
            return null;
        }

        Map<String, String> getDefinitions() {
            return Maps.newHashMap();
        }

        String getAsmFilename() {
            return this.asmFilename;
        }

        ArchitectureDescriptor buildDescriptor(File basePath, File vsPath) {
            File commonTools = new File(vsPath, DefaultVisualStudioLocator.PATH_COMMONTOOLS);
            File commonIde = new File(vsPath, DefaultVisualStudioLocator.PATH_COMMONIDE);
            ArrayList paths = Lists.newArrayList((Object[])new File[]{commonTools, commonIde});
            File crossCompilePath = this.getCrossCompilePath(basePath);
            if (crossCompilePath != null) {
                paths.add(crossCompilePath);
            }
            File includePath = new File(basePath, DefaultVisualStudioLocator.PATH_INCLUDE);
            return new DefaultArchitectureDescriptor(paths, this.getBinPath(basePath), this.getLibPath(basePath), this.getCompilerPath(basePath), includePath, this.asmFilename, this.getDefinitions());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultArchitectureDescriptor
    implements ArchitectureDescriptor {
        private final List<File> paths;
        private final File binPath;
        private final File libPath;
        private final File includePath;
        private final String assemblerFilename;
        private final Map<String, String> definitions;
        private final File compilerPath;

        DefaultArchitectureDescriptor(List<File> paths, File binPath, File libPath, File compilerPath, File includePath, String assemblerFilename, Map<String, String> definitions) {
            this.paths = paths;
            this.binPath = binPath;
            this.libPath = libPath;
            this.includePath = includePath;
            this.assemblerFilename = assemblerFilename;
            this.definitions = definitions;
            this.compilerPath = compilerPath;
        }

        @Override
        public List<File> getPaths() {
            return this.paths;
        }

        @Override
        public File getBinaryPath() {
            return this.binPath;
        }

        @Override
        public File getLibraryPath() {
            return this.libPath;
        }

        @Override
        public File getIncludePath() {
            return this.includePath;
        }

        @Override
        public String getAssemblerFilename() {
            return this.assemblerFilename;
        }

        @Override
        public Map<String, String> getDefinitions() {
            return this.definitions;
        }

        @Override
        public boolean isInstalled() {
            return this.binPath.exists() && this.compilerPath.exists() && this.libPath.exists();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstallNotFound
    implements VisualStudioLocator.SearchResult {
        private final String message;

        private InstallNotFound(String message) {
            this.message = message;
        }

        @Override
        public VisualStudioInstall getVisualStudio() {
            return null;
        }

        public boolean isAvailable() {
            return false;
        }

        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)this.message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstallFound
    implements VisualStudioLocator.SearchResult {
        private final VisualStudioInstall install;

        public InstallFound(VisualStudioInstall install) {
            this.install = install;
        }

        @Override
        public VisualStudioInstall getVisualStudio() {
            return this.install;
        }

        public boolean isAvailable() {
            return true;
        }

        public void explain(TreeVisitor<? super String> visitor) {
        }
    }
}

