/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.pom;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.Conf2ScopeMapping;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.publication.maven.internal.VersionRangeMapper;
import org.gradle.api.publication.maven.internal.pom.ExcludeRuleConverter;
import org.gradle.api.publication.maven.internal.pom.PomDependenciesConverter;
import org.gradle.api.publication.maven.internal.pom.ProjectDependencyArtifactIdExtractorHack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultPomDependenciesConverter
implements PomDependenciesConverter {
    private static final List<Exclusion> EXCLUDE_ALL = DefaultPomDependenciesConverter.initExcludeAll();
    private ExcludeRuleConverter excludeRuleConverter;
    private VersionRangeMapper versionRangeMapper;

    public DefaultPomDependenciesConverter(ExcludeRuleConverter excludeRuleConverter, VersionRangeMapper versionRangeMapper) {
        this.excludeRuleConverter = excludeRuleConverter;
        this.versionRangeMapper = versionRangeMapper;
    }

    public List<Dependency> convert(Conf2ScopeMappingContainer conf2ScopeMappingContainer, Set<Configuration> configurations) {
        Map<ModuleDependency, Set<Configuration>> dependencyToConfigurations = this.createDependencyToConfigurationsMap(configurations);
        Map<ModuleDependency, Conf2ScopeMapping> dependenciesMap = this.createDependencyToScopeMap(conf2ScopeMappingContainer, dependencyToConfigurations);
        LinkedHashMap<Dependency, Integer> dependenciesWithPriorities = new LinkedHashMap<Dependency, Integer>();
        for (ModuleDependency dependency : dependenciesMap.keySet()) {
            Conf2ScopeMapping conf2ScopeMapping = dependenciesMap.get(dependency);
            String scope = conf2ScopeMapping.getScope();
            Integer priority = conf2ScopeMapping.getPriority() == null ? 0 : conf2ScopeMapping.getPriority();
            Set<Configuration> dependencyConfigurations = dependencyToConfigurations.get(dependency);
            if (dependency.getArtifacts().size() == 0) {
                this.addFromDependencyDescriptor(dependenciesWithPriorities, dependency, scope, priority, dependencyConfigurations);
                continue;
            }
            this.addFromArtifactDescriptor(dependenciesWithPriorities, dependency, scope, priority, dependencyConfigurations);
        }
        return new ArrayList<Dependency>(dependenciesWithPriorities.keySet());
    }

    private Map<ModuleDependency, Conf2ScopeMapping> createDependencyToScopeMap(Conf2ScopeMappingContainer conf2ScopeMappingContainer, Map<ModuleDependency, Set<Configuration>> dependencyToConfigurations) {
        LinkedHashMap<ModuleDependency, Conf2ScopeMapping> dependencyToScope = new LinkedHashMap<ModuleDependency, Conf2ScopeMapping>();
        for (ModuleDependency dependency : dependencyToConfigurations.keySet()) {
            Conf2ScopeMapping conf2ScopeDependencyMapping = conf2ScopeMappingContainer.getMapping((Collection<Configuration>)dependencyToConfigurations.get(dependency));
            if (!this.useScope(conf2ScopeMappingContainer, conf2ScopeDependencyMapping)) continue;
            dependencyToScope.put(this.findDependency(dependency, conf2ScopeDependencyMapping.getConfiguration()), conf2ScopeDependencyMapping);
        }
        return dependencyToScope;
    }

    private ModuleDependency findDependency(ModuleDependency dependency, Configuration configuration) {
        for (ModuleDependency configurationDependency : configuration.getDependencies().withType(ModuleDependency.class)) {
            if (!dependency.equals(configurationDependency)) continue;
            return configurationDependency;
        }
        throw new GradleException("Dependency could not be found. We should never get here!");
    }

    private boolean useScope(Conf2ScopeMappingContainer conf2ScopeMappingContainer, Conf2ScopeMapping conf2ScopeMapping) {
        return conf2ScopeMapping.getScope() != null || !conf2ScopeMappingContainer.isSkipUnmappedConfs();
    }

    private Map<ModuleDependency, Set<Configuration>> createDependencyToConfigurationsMap(Set<Configuration> configurations) {
        LinkedHashMap<ModuleDependency, Set<Configuration>> dependencySetMap = new LinkedHashMap<ModuleDependency, Set<Configuration>>();
        for (Configuration configuration : configurations) {
            for (ModuleDependency dependency : configuration.getDependencies().withType(ModuleDependency.class)) {
                if (dependencySetMap.get(dependency) == null) {
                    dependencySetMap.put(dependency, new HashSet());
                }
                ((Set)dependencySetMap.get(dependency)).add(configuration);
            }
        }
        return dependencySetMap;
    }

    private void addFromArtifactDescriptor(Map<Dependency, Integer> dependenciesPriorityMap, ModuleDependency dependency, String scope, Integer priority, Set<Configuration> configurations) {
        for (DependencyArtifact artifact : dependency.getArtifacts()) {
            this.addMavenDependencies(dependenciesPriorityMap, dependency, artifact.getName(), artifact.getType(), scope, artifact.getClassifier(), priority, configurations);
        }
    }

    private void addFromDependencyDescriptor(Map<Dependency, Integer> dependenciesPriorityMap, ModuleDependency dependency, String scope, Integer priority, Set<Configuration> configurations) {
        this.addMavenDependencies(dependenciesPriorityMap, dependency, dependency.getName(), null, scope, null, priority, configurations);
    }

    private void addMavenDependencies(Map<Dependency, Integer> dependenciesWithPriorities, ModuleDependency dependency, String name, String type, String scope, String classifier, Integer priority, Set<Configuration> configurations) {
        ArrayList<Dependency> mavenDependencies = new ArrayList<Dependency>();
        if (dependency instanceof ProjectDependency) {
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            String artifactId = this.determineProjectDependencyArtifactId((ProjectDependency)dependency);
            Configuration dependencyConfig = projectDependency.getProjectConfiguration();
            for (PublishArtifact artifactToPublish : dependencyConfig.getAllArtifacts()) {
                Dependency mavenDependency = new Dependency();
                mavenDependency.setArtifactId(artifactId);
                if (artifactToPublish.getClassifier() != null && !artifactToPublish.getClassifier().equals("")) {
                    mavenDependency.setClassifier(artifactToPublish.getClassifier());
                }
                mavenDependencies.add(mavenDependency);
            }
        } else {
            Dependency mavenDependency = new Dependency();
            mavenDependency.setArtifactId(name);
            mavenDependency.setClassifier(classifier);
            mavenDependencies.add(mavenDependency);
        }
        for (Dependency mavenDependency : mavenDependencies) {
            boolean higherVersion;
            mavenDependency.setGroupId(dependency.getGroup());
            mavenDependency.setVersion(this.mapToMavenSyntax(dependency.getVersion()));
            mavenDependency.setType(type);
            mavenDependency.setScope(scope);
            mavenDependency.setExclusions(this.getExclusions(dependency, configurations));
            Optional<Dependency> duplicateDependency = this.findEqualIgnoreScopeVersionAndExclusions(dependenciesWithPriorities.keySet(), mavenDependency);
            if (!duplicateDependency.isPresent()) {
                dependenciesWithPriorities.put(mavenDependency, priority);
                continue;
            }
            int duplicatePriority = dependenciesWithPriorities.get(duplicateDependency.get());
            DefaultArtifactVersion mavenVersion = new DefaultArtifactVersion(mavenDependency.getVersion());
            DefaultArtifactVersion duplicateVersion = new DefaultArtifactVersion(((Dependency)duplicateDependency.get()).getVersion());
            boolean higherPriority = priority > duplicatePriority;
            boolean bl = higherVersion = mavenVersion.compareTo((Object)duplicateVersion) > 0;
            if (!higherPriority && !higherVersion) continue;
            dependenciesWithPriorities.remove(duplicateDependency.get());
            if (!higherPriority) {
                mavenDependency.setScope(((Dependency)duplicateDependency.get()).getScope());
                mavenDependency.setExclusions(((Dependency)duplicateDependency.get()).getExclusions());
            }
            int highestPriority = higherPriority ? priority : duplicatePriority;
            dependenciesWithPriorities.put(mavenDependency, highestPriority);
        }
    }

    private Optional<Dependency> findEqualIgnoreScopeVersionAndExclusions(Collection<Dependency> dependencies, Dependency candidate) {
        final String candidateManagementKey = candidate.getManagementKey();
        return Iterables.tryFind(dependencies, (Predicate)new Predicate<Dependency>(){

            public boolean apply(Dependency dependency) {
                return dependency.getManagementKey().equals(candidateManagementKey);
            }
        });
    }

    private String mapToMavenSyntax(String version) {
        return this.versionRangeMapper.map(version);
    }

    protected String determineProjectDependencyArtifactId(ProjectDependency dependency) {
        return new ProjectDependencyArtifactIdExtractorHack(dependency).extract();
    }

    private List<Exclusion> getExclusions(ModuleDependency dependency, Set<Configuration> configurations) {
        if (!dependency.isTransitive()) {
            return EXCLUDE_ALL;
        }
        ArrayList<Exclusion> mavenExclusions = new ArrayList<Exclusion>();
        HashSet excludeRules = new HashSet(dependency.getExcludeRules());
        for (Configuration configuration : configurations) {
            excludeRules.addAll(configuration.getExcludeRules());
        }
        for (ExcludeRule excludeRule : excludeRules) {
            Exclusion mavenExclusion = (Exclusion)this.excludeRuleConverter.convert(excludeRule);
            if (mavenExclusion == null) continue;
            mavenExclusions.add(mavenExclusion);
        }
        return mavenExclusions;
    }

    private static List<Exclusion> initExcludeAll() {
        Exclusion excludeAll = new Exclusion();
        excludeAll.setGroupId("*");
        excludeAll.setArtifactId("*");
        return Collections.singletonList(excludeAll);
    }

    public ExcludeRuleConverter getExcludeRuleConverter() {
        return this.excludeRuleConverter;
    }
}

