/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import org.apache.batik.anim.dom.AttributeInitializer;
import org.apache.batik.anim.dom.SVGOMAnimatedString;
import org.apache.batik.anim.dom.SVGStylableElement;
import org.apache.batik.dom.AbstractDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGGlyphRefElement;

public class SVGOMGlyphRefElement
extends SVGStylableElement
implements SVGGlyphRefElement {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(4);
    protected SVGOMAnimatedString href;

    protected SVGOMGlyphRefElement() {
    }

    public SVGOMGlyphRefElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.initializeLiveAttributes();
    }

    @Override
    protected void initializeAllLiveAttributes() {
        super.initializeAllLiveAttributes();
        this.initializeLiveAttributes();
    }

    private void initializeLiveAttributes() {
        this.href = this.createLiveAnimatedString("http://www.w3.org/1999/xlink", "href");
    }

    @Override
    public String getLocalName() {
        return "glyphRef";
    }

    public SVGAnimatedString getHref() {
        return this.href;
    }

    public String getGlyphRef() {
        return this.getAttributeNS(null, "glyphRef");
    }

    public void setGlyphRef(String string) throws DOMException {
        this.setAttributeNS(null, "glyphRef", string);
    }

    public String getFormat() {
        return this.getAttributeNS(null, "format");
    }

    public void setFormat(String string) throws DOMException {
        this.setAttributeNS(null, "format", string);
    }

    public float getX() {
        return Float.parseFloat(this.getAttributeNS(null, "x"));
    }

    public void setX(float f) throws DOMException {
        this.setAttributeNS(null, "x", String.valueOf(f));
    }

    public float getY() {
        return Float.parseFloat(this.getAttributeNS(null, "y"));
    }

    public void setY(float f) throws DOMException {
        this.setAttributeNS(null, "y", String.valueOf(f));
    }

    public float getDx() {
        return Float.parseFloat(this.getAttributeNS(null, "dx"));
    }

    public void setDx(float f) throws DOMException {
        this.setAttributeNS(null, "dx", String.valueOf(f));
    }

    public float getDy() {
        return Float.parseFloat(this.getAttributeNS(null, "dy"));
    }

    public void setDy(float f) throws DOMException {
        this.setAttributeNS(null, "dy", String.valueOf(f));
    }

    @Override
    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    @Override
    protected Node newNode() {
        return new SVGOMGlyphRefElement();
    }

    static {
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns:xlink", "http://www.w3.org/1999/xlink");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "type", "simple");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "show", "other");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "actuate", "onLoad");
    }
}

