/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.dialogs.OsmIdSelectionDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class HistoryInfoAction
extends JosmAction {
    public HistoryInfoAction() {
        super(I18n.tr("History", new Object[0]), "dialogs/history", I18n.tr("Display history information about OSM ways, nodes, or relations.", new Object[0]), Shortcut.registerShortcut("core:historyinfo", I18n.tr("History", new Object[0]), 72, 5006), false);
        this.putValue("help", HelpUtil.ht("/Action/ObjectHistory"));
        this.putValue("toolbar", "action/historyinfo");
        Main.toolbar.register(this);
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet != null && !dataSet.selectionEmpty()) {
            HistoryBrowserDialogManager.getInstance().showHistory(dataSet.getAllSelected());
        } else {
            HistoryObjectIDDialog historyObjectIDDialog = new HistoryObjectIDDialog();
            if (historyObjectIDDialog.showDialog().getValue() == historyObjectIDDialog.getContinueButtonIndex()) {
                HistoryBrowserDialogManager.getInstance().showHistory(historyObjectIDDialog.getOsmIds());
            }
        }
    }

    public static class HistoryObjectIDDialog
    extends OsmIdSelectionDialog {
        public HistoryObjectIDDialog() {
            super(Main.parent, I18n.tr("Show history", new Object[0]), new String[]{I18n.tr("Show history", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.setButtonIcons(new String[]{"dialogs/history", "cancel"});
            this.init();
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            ((JButton)this.buttons.get(0)).setEnabled(!Main.isOffline(OnlineResource.OSM_API));
        }
    }
}

