/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.Collections;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.platform.UnsafeGroup;

@CoreClass(value="Truffle::Process")
public abstract class TruffleProcessNodes {

    @CoreMethod(names={"spawn"}, onSingleton=true, required=3, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SpawnNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(command)", "isRubyArray(arguments)", "isRubyArray(environmentVariables)"})
        public int spawn(DynamicObject command, DynamicObject arguments, DynamicObject environmentVariables) {
            long longPid = this.call(StringOperations.getString(this.getContext(), command), this.toStringArray(arguments), this.toStringArray(environmentVariables));
            assert (longPid <= Integer.MAX_VALUE);
            int pid = (int)longPid;
            if (pid == -1) {
                throw new RaiseException(this.coreExceptions().errnoError(this.getContext().getNativePlatform().getPosix().errno(), this));
            }
            return pid;
        }

        private String[] toStringArray(DynamicObject rubyStrings) {
            int size = Layouts.ARRAY.getSize(rubyStrings);
            Object[] unconvertedStrings = ArrayOperations.toObjectArray(rubyStrings);
            String[] strings = new String[size];
            for (int i = 0; i < size; ++i) {
                assert (Layouts.STRING.isString(unconvertedStrings[i]));
                strings[i] = StringOperations.getString(this.getContext(), (DynamicObject)unconvertedStrings[i]);
            }
            return strings;
        }

        @CompilerDirectives.TruffleBoundary
        private long call(String command, String[] arguments, String[] environmentVariables) {
            return this.getContext().getNativePlatform().getPosix().posix_spawnp(command, Collections.emptyList(), Arrays.asList(arguments), Arrays.asList(environmentVariables));
        }
    }
}

