/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;

@NodeChild(value="child")
public abstract class HashCastNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toHashNode;

    public HashCastNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toHashNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
    }

    protected abstract RubyNode getChild();

    @Specialization
    public DynamicObject cast(boolean value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(int value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(long value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(double value) {
        return this.nil();
    }

    @Specialization(guards={"isNil(nil)"})
    public DynamicObject castNil(DynamicObject nil) {
        return this.nil();
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject castBignum(DynamicObject value) {
        return this.nil();
    }

    @Specialization(guards={"isRubyHash(hash)"})
    public DynamicObject castHash(DynamicObject hash) {
        return hash;
    }

    @Specialization(guards={"!isNil(object)", "!isRubyBignum(object)", "!isRubyHash(object)"})
    public Object cast(VirtualFrame frame, DynamicObject object, @Cached(value="create()") BranchProfile errorProfile) {
        Object result = this.toHashNode.call(frame, object, "to_hash", null, new Object[0]);
        if (result == DispatchNode.MISSING) {
            return this.nil();
        }
        if (!RubyGuards.isRubyHash(result)) {
            errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeErrorCantConvertTo(object, "Hash", "to_hash", result, this));
        }
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.getChild().executeVoid(frame);
    }
}

