/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class ToIntegerNode
extends FormatNode {
    @Node.Child
    private CallDispatchHeadNode integerNode;

    public ToIntegerNode(RubyContext context) {
        super(context);
    }

    public abstract Object executeToInteger(VirtualFrame var1, Object var2);

    @Specialization
    public int toInteger(int value) {
        return value;
    }

    @Specialization
    public long toInteger(long value) {
        return value;
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject toInteger(DynamicObject value) {
        return value;
    }

    @Specialization
    public long toInteger(double value) {
        return (long)value;
    }

    @Specialization(guards={"!isInteger(value)", "!isLong(value)", "!isRubyBignum(value)"})
    public Object toInteger(VirtualFrame frame, Object value) {
        if (this.integerNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.integerNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
        }
        return this.integerNode.call(frame, this.getContext().getCoreLibrary().getKernelModule(), "Integer", null, value);
    }
}

