/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.globals.ReadThreadLocalGlobalVariableNode;

public class ReadLastBacktraceNode
extends RubyNode {
    @Node.Child
    private ReadThreadLocalGlobalVariableNode getLastExceptionNode;
    @Node.Child
    private CallDispatchHeadNode getBacktraceNode;
    private final ConditionProfile lastExceptionNilProfile = ConditionProfile.createBinaryProfile();

    public ReadLastBacktraceNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object lastException = this.getGetLastExceptionNode().execute(frame);
        if (this.lastExceptionNilProfile.profile(lastException == this.nil())) {
            return this.nil();
        }
        return this.getGetBacktraceNode().call(frame, lastException, "backtrace", null, new Object[0]);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.coreStrings().GLOBAL_VARIABLE.createInstance();
    }

    private ReadThreadLocalGlobalVariableNode getGetLastExceptionNode() {
        if (this.getLastExceptionNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.getLastExceptionNode = this.insert(new ReadThreadLocalGlobalVariableNode(this.getContext(), this.getSourceSection(), "$!", true));
        }
        return this.getLastExceptionNode;
    }

    private CallDispatchHeadNode getGetBacktraceNode() {
        if (this.getBacktraceNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.getBacktraceNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        return this.getBacktraceNode;
    }
}

