/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNodeGen;

public class ReadThreadLocalGlobalVariableNode
extends RubyNode {
    private final String name;
    private final boolean alwaysDefined;
    @Node.Child
    private ThreadLocalObjectNode threadLocalVariablesObjectNode;
    @Node.Child
    private ReadObjectFieldNode readNode;

    public ReadThreadLocalGlobalVariableNode(RubyContext context, SourceSection sourceSection, String name, boolean alwaysDefined) {
        super(context, sourceSection);
        this.name = name;
        this.alwaysDefined = alwaysDefined;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject threadLocalVariablesObject = this.getThreadLocalVariablesObjectNode().executeDynamicObject(frame);
        return this.getReadNode().execute(threadLocalVariablesObject);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (this.alwaysDefined || this.execute(frame) != this.nil()) {
            return this.coreStrings().GLOBAL_VARIABLE.createInstance();
        }
        return this.nil();
    }

    private ThreadLocalObjectNode getThreadLocalVariablesObjectNode() {
        if (this.threadLocalVariablesObjectNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.threadLocalVariablesObjectNode = this.insert(ThreadLocalObjectNodeGen.create(this.getContext(), this.getSourceSection()));
        }
        return this.threadLocalVariablesObjectNode;
    }

    private ReadObjectFieldNode getReadNode() {
        if (this.readNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.readNode = this.insert(ReadObjectFieldNodeGen.create(this.name, this.nil()));
        }
        return this.readNode;
    }
}

