/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.Locale;
import java.util.StringTokenizer;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderRobotstxtParser
extends SpiderParser {
    private static final String PATTERNS_USERAGENT = "(?i)^User-agent:.*";
    private static final String PATTERNS_DISALLOW = "(?i)Disallow:.*";
    private static final String PATTERNS_ALLOW = "(?i)Allow:.*";
    private static final int PATTERNS_USERAGENT_LENGTH = 11;
    private static final int PATTERNS_DISALLOW_LENGTH = 9;
    private static final int PATTERNS_ALLOW_LENGTH = 6;
    private SpiderParam params;

    public SpiderRobotstxtParser(SpiderParam spiderParam) {
        this.params = spiderParam;
    }

    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        if (httpMessage == null || !this.params.isParseRobotsTxt()) {
            return false;
        }
        log.debug((Object)"Parsing a robots.txt resource...");
        String string = httpMessage.getResponseBody().toString();
        String string2 = httpMessage.getRequestHeader().getURI().toString();
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n2 = string4.indexOf("#");
            if (n2 != -1) {
                string4 = string4.substring(0, n2);
            }
            string4 = string4.replaceAll("<[^>]+>", "");
            if ((string4 = string4.trim()).length() == 0) continue;
            log.debug((Object)("Processing robots.txt line: " + string4));
            if (string4.matches(PATTERNS_USERAGENT)) {
                string3 = string4.substring(11).trim().toLowerCase(Locale.ENGLISH);
                if (string3.equals("*") || string3.contains("")) {
                    log.debug((Object)"Parsing robots.txt file. Starting section applying to spider.");
                    bl = true;
                    continue;
                }
                log.debug((Object)"Parsing robots.txt file. Start section not applying to spider.");
                bl = false;
                continue;
            }
            if (string4.matches(PATTERNS_DISALLOW)) {
                string3 = string4.substring(9).trim();
                if (string3.endsWith("*")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if ((string3 = string3.trim()).length() <= 0) continue;
                this.processURL(httpMessage, n, string3, string2);
                continue;
            }
            if (!string4.matches(PATTERNS_ALLOW)) continue;
            string3 = string4.substring(6).trim();
            if (string3.endsWith("*")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((string3 = string3.trim()).length() <= 0) continue;
            this.processURL(httpMessage, n, string3, string2);
        }
        return true;
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        return string != null && string.equalsIgnoreCase("/robots.txt");
    }
}

