/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Apt;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class AptCompilerAdapter
extends DefaultCompilerAdapter {
    private static final int APT_COMPILER_SUCCESS = 0;
    public static final String APT_ENTRY_POINT = "com.sun.tools.apt.Main";
    public static final String APT_METHOD_NAME = "process";

    protected Apt getApt() {
        return (Apt)this.getJavac();
    }

    static void setAptCommandlineSwitches(Apt apt, Commandline cmd) {
        File preprocessDir;
        Path factoryPath;
        String factory;
        if (!apt.isCompile()) {
            cmd.createArgument().setValue("-nocompile");
        }
        if ((factory = apt.getFactory()) != null) {
            cmd.createArgument().setValue("-factory");
            cmd.createArgument().setValue(factory);
        }
        if ((factoryPath = apt.getFactoryPath()) != null) {
            cmd.createArgument().setValue("-factorypath");
            cmd.createArgument().setPath(factoryPath);
        }
        if ((preprocessDir = apt.getPreprocessDir()) != null) {
            cmd.createArgument().setValue("-s");
            cmd.createArgument().setFile(preprocessDir);
        }
        Vector options = apt.getOptions();
        Enumeration elements = options.elements();
        StringBuffer arg = null;
        while (elements.hasMoreElements()) {
            Apt.Option opt = (Apt.Option)elements.nextElement();
            arg = new StringBuffer();
            arg.append("-A").append(opt.getName());
            if (opt.getValue() != null) {
                arg.append("=").append(opt.getValue());
            }
            cmd.createArgument().setValue(arg.toString());
        }
    }

    protected void setAptCommandlineSwitches(Commandline cmd) {
        Apt apt = this.getApt();
        AptCompilerAdapter.setAptCommandlineSwitches(apt, cmd);
    }

    public boolean execute() throws BuildException {
        this.attributes.log("Using apt compiler", 3);
        Commandline cmd = this.setupModernJavacCommand();
        this.setAptCommandlineSwitches(cmd);
        try {
            Class<?> c = Class.forName(APT_ENTRY_POINT);
            Object compiler = c.newInstance();
            Method compile = c.getMethod(APT_METHOD_NAME, new String[0].getClass());
            int result = (Integer)compile.invoke(compiler, new Object[]{cmd.getArguments()});
            return result == 0;
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception ex) {
            throw new BuildException("Error starting apt compiler", ex, this.location);
        }
    }
}

