/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagerBase
implements Manager,
MBeanRegistration {
    protected Log log = LogFactory.getLog(ManagerBase.class);
    private static final String devRandomSourceDefault;
    protected DataInputStream randomIS = null;
    protected String devRandomSource = devRandomSourceDefault;
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected String algorithm = "MD5";
    protected Container container;
    protected MessageDigest digest = null;
    @Deprecated
    protected boolean distributable;
    protected String entropy = null;
    private static final String info = "ManagerBase/1.0";
    @Deprecated
    protected int maxInactiveInterval = 1800;
    protected int sessionIdLength = 16;
    protected static String name;
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected int sessionMaxAliveTime;
    protected int sessionAverageAliveTime;
    protected static final int TIMING_STATS_CACHE_SIZE = 100;
    protected LinkedList<SessionTiming> sessionCreationTiming = new LinkedList();
    protected LinkedList<SessionTiming> sessionExpirationTiming = new LinkedList();
    protected int expiredSessions = 0;
    protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    protected int sessionCounter = 0;
    protected volatile int maxActive = 0;
    private final Object maxActiveUpdateLock = new Object();
    protected int duplicates = 0;
    protected boolean initialized = false;
    protected long processingTime = 0L;
    private int count = 0;
    protected int processExpiresFrequency = 6;
    protected static final StringManager sm;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Pattern sessionAttributeNamePattern;
    private Pattern sessionAttributeValueClassNamePattern;
    private boolean warnOnSessionAttributeFilterFailure;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public ManagerBase() {
        if (Globals.IS_SECURITY_ENABLED) {
            this.setSessionAttributeValueClassNameFilter("java\\.lang\\.(?:Boolean|Integer|Long|Number|String)");
            this.setWarnOnSessionAttributeFilterFailure(true);
        }
    }

    public String getSessionAttributeNameFilter() {
        if (this.sessionAttributeNamePattern == null) {
            return null;
        }
        return this.sessionAttributeNamePattern.toString();
    }

    public void setSessionAttributeNameFilter(String sessionAttributeNameFilter) {
        this.sessionAttributeNamePattern = sessionAttributeNameFilter == null || sessionAttributeNameFilter.length() == 0 ? null : Pattern.compile(sessionAttributeNameFilter);
    }

    protected Pattern getSessionAttributeNamePattern() {
        return this.sessionAttributeNamePattern;
    }

    public String getSessionAttributeValueClassNameFilter() {
        if (this.sessionAttributeValueClassNamePattern == null) {
            return null;
        }
        return this.sessionAttributeValueClassNamePattern.toString();
    }

    protected Pattern getSessionAttributeValueClassNamePattern() {
        return this.sessionAttributeValueClassNamePattern;
    }

    public void setSessionAttributeValueClassNameFilter(String sessionAttributeValueClassNameFilter) throws PatternSyntaxException {
        this.sessionAttributeValueClassNamePattern = sessionAttributeValueClassNameFilter == null || sessionAttributeValueClassNameFilter.length() == 0 ? null : Pattern.compile(sessionAttributeValueClassNameFilter);
    }

    public boolean getWarnOnSessionAttributeFilterFailure() {
        return this.warnOnSessionAttributeFilterFailure;
    }

    public void setWarnOnSessionAttributeFilterFailure(boolean warnOnSessionAttributeFilterFailure) {
        this.warnOnSessionAttributeFilterFailure = warnOnSessionAttributeFilterFailure;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        String oldAlgorithm = this.algorithm;
        this.algorithm = algorithm;
        this.support.firePropertyChange("algorithm", oldAlgorithm, this.algorithm);
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        if (this.container == container) {
            return;
        }
        if (this.initialized) {
            throw new IllegalStateException(sm.getString("managerBase.setContextNotNew"));
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            long t1 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.getting", this.algorithm));
            }
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((Object)sm.getString("managerBase.digest", this.algorithm), (Throwable)e);
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.log.error((Object)sm.getString("managerBase.digest", DEFAULT_ALGORITHM), (Throwable)e);
                    this.digest = null;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.gotten"));
            }
            long t2 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getDigest() " + (t2 - t1)));
            }
        }
        return this.digest;
    }

    @Override
    @Deprecated
    public boolean getDistributable() {
        Container container = this.getContainer();
        if (container instanceof Context) {
            return ((Context)container).getDistributable();
        }
        return false;
    }

    @Override
    @Deprecated
    public void setDistributable(boolean distributable) {
    }

    public String getEntropy() {
        if (this.entropy == null) {
            byte[] result = new byte[32];
            boolean apr = false;
            try {
                String methodName = "random";
                Class[] paramTypes = new Class[]{result.getClass(), Integer.TYPE};
                Object[] paramValues = new Object[]{result, new Integer(32)};
                Method method = Class.forName("org.apache.tomcat.jni.OS").getMethod(methodName, paramTypes);
                method.invoke(null, paramValues);
                apr = true;
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (apr) {
                try {
                    this.setEntropy(new String(result, "ISO-8859-1"));
                }
                catch (UnsupportedEncodingException ux) {
                    throw new Error(ux);
                }
            } else {
                this.setEntropy(this.toString());
            }
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    @Override
    @Deprecated
    public String getInfo() {
        return info;
    }

    @Override
    public int getMaxInactiveInterval() {
        Container container = this.getContainer();
        if (container instanceof Context) {
            return ((Context)container).getSessionTimeout();
        }
        return -1;
    }

    @Override
    @Deprecated
    public void setMaxInactiveInterval(int interval) {
    }

    @Override
    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Override
    public void setSessionIdLength(int idLength) {
        int oldSessionIdLength = this.sessionIdLength;
        this.sessionIdLength = idLength;
        this.support.firePropertyChange("sessionIdLength", new Integer(oldSessionIdLength), new Integer(this.sessionIdLength));
    }

    public String getName() {
        return name;
    }

    public void setRandomFile(String s) {
        if (Globals.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new PrivilegedSetRandomFile(s));
        } else {
            this.doSetRandomFile(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetRandomFile(String s) {
        block23: {
            FilterInputStream is = null;
            try {
                if (s == null || s.length() == 0) {
                    return;
                }
                File f = new File(s);
                if (!f.exists()) {
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Opening " + s));
                }
                is = new DataInputStream(new FileInputStream(f));
                ((DataInputStream)is).readLong();
            }
            catch (IOException ex) {
                this.log.warn((Object)("Error reading " + s), (Throwable)ex);
                if (is == null) break block23;
                try {
                    is.close();
                }
                catch (Exception ex2) {
                    this.log.warn((Object)("Failed to close " + s), (Throwable)ex2);
                }
                is = null;
            }
            finally {
                DataInputStream oldIS = this.randomIS;
                this.devRandomSource = is != null ? s : null;
                this.randomIS = is;
                if (oldIS != null) {
                    try {
                        oldIS.close();
                    }
                    catch (Exception ex) {
                        this.log.warn((Object)"Failed to close RandomIS", (Throwable)ex);
                    }
                }
            }
        }
    }

    public String getRandomFile() {
        return this.devRandomSource;
    }

    public Random getRandom() {
        if (this.random == null) {
            long t2;
            long seed;
            long t1 = seed = System.currentTimeMillis();
            char[] entropy = this.getEntropy().toCharArray();
            for (int i = 0; i < entropy.length; ++i) {
                long update = (long)entropy[i] << i % 8 * 8;
                seed ^= update;
            }
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                this.random.setSeed(seed);
            }
            catch (Exception e) {
                this.log.error((Object)sm.getString("managerBase.random", this.randomClass), (Throwable)e);
                this.random = new Random();
                this.random.setSeed(seed);
            }
            if (this.log.isDebugEnabled() && (t2 = System.currentTimeMillis()) - t1 > 100L) {
                this.log.debug((Object)(sm.getString("managerBase.seeding", this.randomClass) + " " + (t2 - t1)));
            }
        }
        return this.random;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        String oldRandomClass = this.randomClass;
        this.randomClass = randomClass;
        this.support.firePropertyChange("randomClass", oldRandomClass, this.randomClass);
    }

    @Override
    public int getExpiredSessions() {
        return this.expiredSessions;
    }

    @Override
    public void setExpiredSessions(int expiredSessions) {
        this.expiredSessions = expiredSessions;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public int getProcessExpiresFrequency() {
        return this.processExpiresFrequency;
    }

    public void setProcessExpiresFrequency(int processExpiresFrequency) {
        if (processExpiresFrequency <= 0) {
            return;
        }
        int oldProcessExpiresFrequency = this.processExpiresFrequency;
        this.processExpiresFrequency = processExpiresFrequency;
        this.support.firePropertyChange("processExpiresFrequency", new Integer(oldProcessExpiresFrequency), new Integer(this.processExpiresFrequency));
    }

    @Override
    public void backgroundProcess() {
        this.count = (this.count + 1) % this.processExpiresFrequency;
        if (this.count == 0) {
            this.processExpires();
        }
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireHere = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Start expire sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length));
        }
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i] == null || sessions[i].isValid()) continue;
            ++expireHere;
        }
        long timeEnd = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("End expire sessions " + this.getName() + " processingTime " + (timeEnd - timeNow) + " expired sessions: " + expireHere));
        }
        this.processingTime += timeEnd - timeNow;
    }

    public void destroy() {
        if (this.oname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
        if (this.randomIS != null) {
            try {
                this.randomIS.close();
            }
            catch (IOException ioe) {
                this.log.warn((Object)"Failed to close randomIS.");
            }
            this.randomIS = null;
        }
        this.initialized = false;
        this.oname = null;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.log = LogFactory.getLog(ManagerBase.class);
        if (this.oname == null) {
            try {
                StandardContext ctx = (StandardContext)this.getContainer();
                this.domain = ctx.getEngineName();
                this.distributable = ctx.getDistributable();
                StandardHost hst = (StandardHost)ctx.getParent();
                String path = ctx.getPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.oname = new ObjectName(this.domain + ":type=Manager,path=" + path + ",host=" + hst.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                this.log.error((Object)"Error registering ", (Throwable)e);
            }
        }
        this.getRandomBytes(new byte[16]);
        if (!(this.container instanceof Context)) {
            throw new IllegalStateException(sm.getString("managerBase.contextNull"));
        }
        while (this.sessionCreationTiming.size() < 100) {
            this.sessionCreationTiming.add(null);
        }
        while (this.sessionExpirationTiming.size() < 100) {
            this.sessionExpirationTiming.add(null);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering " + this.oname));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session) {
        this.sessions.put(session.getIdInternal(), session);
        int size = this.sessions.size();
        if (size > this.maxActive) {
            Object object = this.maxActiveUpdateLock;
            synchronized (object) {
                if (size > this.maxActive) {
                    this.maxActive = size;
                }
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    @Deprecated
    public Session createSession() {
        return this.createSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session createSession(String sessionId) {
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(((Context)this.getContainer()).getSessionTimeout() * 60);
        if (sessionId == null) {
            sessionId = this.generateSessionId();
        }
        session.setId(sessionId);
        ++this.sessionCounter;
        SessionTiming timing = new SessionTiming(session.getCreationTime(), 0);
        LinkedList<SessionTiming> linkedList = this.sessionCreationTiming;
        synchronized (linkedList) {
            this.sessionCreationTiming.add(timing);
            this.sessionCreationTiming.poll();
        }
        return session;
    }

    @Override
    public Session createEmptySession() {
        return this.getNewSession();
    }

    @Override
    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    @Override
    public Session[] findSessions() {
        return this.sessions.values().toArray(new Session[0]);
    }

    @Override
    public void remove(Session session) {
        this.sessions.remove(session.getIdInternal());
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void changeSessionId(Session session) {
        String oldId = session.getIdInternal();
        session.setId(this.generateSessionId(), false);
        String newId = session.getIdInternal();
        if (this.container instanceof ContainerBase) {
            ((ContainerBase)this.container).fireContainerEvent("changeSessionId", new String[]{oldId, newId});
        }
    }

    @Override
    public boolean willAttributeDistribute(String name, Object value) {
        Pattern sessionAttributeNamePattern = this.getSessionAttributeNamePattern();
        if (sessionAttributeNamePattern != null && !sessionAttributeNamePattern.matcher(name).matches()) {
            if (this.getWarnOnSessionAttributeFilterFailure() || this.log.isDebugEnabled()) {
                String msg = sm.getString("managerBase.sessionAttributeNameFilter", name, sessionAttributeNamePattern);
                if (this.getWarnOnSessionAttributeFilterFailure()) {
                    this.log.warn((Object)msg);
                } else {
                    this.log.debug((Object)msg);
                }
            }
            return false;
        }
        Pattern sessionAttributeValueClassNamePattern = this.getSessionAttributeValueClassNamePattern();
        if (value != null && sessionAttributeValueClassNamePattern != null && !sessionAttributeValueClassNamePattern.matcher(value.getClass().getName()).matches()) {
            if (this.getWarnOnSessionAttributeFilterFailure() || this.log.isDebugEnabled()) {
                String msg = sm.getString("managerBase.sessionAttributeValueClassNameFilter", name, value.getClass().getName(), sessionAttributeNamePattern);
                if (this.getWarnOnSessionAttributeFilterFailure()) {
                    this.log.warn((Object)msg);
                } else {
                    this.log.debug((Object)msg);
                }
            }
            return false;
        }
        return true;
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected void getRandomBytes(byte[] bytes) {
        if (this.devRandomSource != null && this.randomIS == null) {
            this.setRandomFile(this.devRandomSource);
        }
        if (this.randomIS != null) {
            try {
                int len = this.randomIS.read(bytes);
                if (len == bytes.length) {
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Got " + len + " " + bytes.length));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.devRandomSource = null;
            try {
                this.randomIS.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close randomIS.");
            }
            this.randomIS = null;
        }
        this.getRandom().nextBytes(bytes);
    }

    protected synchronized String generateSessionId() {
        byte[] random = new byte[16];
        String jvmRoute = this.getJvmRoute();
        String result = null;
        StringBuffer buffer = new StringBuffer();
        do {
            int resultLenBytes = 0;
            if (result != null) {
                buffer = new StringBuffer();
                ++this.duplicates;
            }
            while (resultLenBytes < this.sessionIdLength) {
                this.getRandomBytes(random);
                random = this.getDigest().digest(random);
                for (int j = 0; j < random.length && resultLenBytes < this.sessionIdLength; ++resultLenBytes, ++j) {
                    byte b1 = (byte)((random[j] & 0xF0) >> 4);
                    byte b2 = (byte)(random[j] & 0xF);
                    if (b1 < 10) {
                        buffer.append((char)(48 + b1));
                    } else {
                        buffer.append((char)(65 + (b1 - 10)));
                    }
                    if (b2 < 10) {
                        buffer.append((char)(48 + b2));
                        continue;
                    }
                    buffer.append((char)(65 + (b2 - 10)));
                }
            }
            if (jvmRoute == null) continue;
            buffer.append('.').append(jvmRoute);
        } while (this.sessions.containsKey(result = buffer.toString()));
        return result;
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (!(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    @Override
    public void setSessionCounter(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    @Override
    public int getSessionCounter() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    @Override
    public int getActiveSessions() {
        return this.sessions.size();
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActive(int maxActive) {
        Object object = this.maxActiveUpdateLock;
        synchronized (object) {
            this.maxActive = maxActive;
        }
    }

    @Override
    public int getSessionMaxAliveTime() {
        return this.sessionMaxAliveTime;
    }

    @Override
    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        this.sessionMaxAliveTime = sessionMaxAliveTime;
    }

    @Override
    public int getSessionAverageAliveTime() {
        return this.sessionAverageAliveTime;
    }

    @Override
    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
        this.sessionAverageAliveTime = sessionAverageAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCreateRate() {
        long now = System.currentTimeMillis();
        ArrayList<SessionTiming> copy = new ArrayList<SessionTiming>();
        LinkedList<SessionTiming> linkedList = this.sessionCreationTiming;
        synchronized (linkedList) {
            copy.addAll(this.sessionCreationTiming);
        }
        long oldest = now;
        int counter = 0;
        int result = 0;
        for (SessionTiming timing : copy) {
            if (timing == null) continue;
            ++counter;
            if (timing.getTimestamp() >= oldest) continue;
            oldest = timing.getTimestamp();
        }
        if (counter > 0) {
            result = oldest < now ? (int)((long)(60000 * counter) / (now - oldest)) : Integer.MAX_VALUE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionExpireRate() {
        long now = System.currentTimeMillis();
        ArrayList<SessionTiming> copy = new ArrayList<SessionTiming>();
        LinkedList<SessionTiming> linkedList = this.sessionExpirationTiming;
        synchronized (linkedList) {
            copy.addAll(this.sessionExpirationTiming);
        }
        long oldest = now;
        int counter = 0;
        int result = 0;
        for (SessionTiming timing : copy) {
            if (timing == null) continue;
            ++counter;
            if (timing.getTimestamp() >= oldest) continue;
            oldest = timing.getTimestamp();
        }
        if (counter > 0) {
            result = oldest < now ? (int)((long)(60000 * counter) / (now - oldest)) : Integer.MAX_VALUE;
        }
        return result;
    }

    public String listSessionIds() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append(keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public HashMap<String, Object> getSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Enumeration ee = s.getSession().getAttributeNames();
        if (ee == null || !ee.hasMoreElements()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (ee.hasMoreElements()) {
            String attrName = (String)ee.nextElement();
            map.put(attrName, this.getSessionAttribute(sessionId, attrName));
        }
        return map;
    }

    public void expireSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return;
        }
        s.expire();
    }

    public long getLastAccessedTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getLastAccessedTime();
    }

    public String getLastAccessedTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }

    public String getCreationTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getCreationTime()).toString();
    }

    public long getCreationTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getCreationTime();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    static {
        File f = new File("/dev/urandom");
        devRandomSourceDefault = f.isAbsolute() && f.exists() ? f.getPath() : null;
        name = "ManagerBase";
        sm = StringManager.getManager("org.apache.catalina.session");
    }

    protected static final class SessionTiming {
        private long timestamp;
        private int duration;

        public SessionTiming(long timestamp, int duration) {
            this.timestamp = timestamp;
            this.duration = duration;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getDuration() {
            return this.duration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrivilegedSetRandomFile
    implements PrivilegedAction<Void> {
        private final String s;

        public PrivilegedSetRandomFile(String s) {
            this.s = s;
        }

        @Override
        public Void run() {
            ManagerBase.this.doSetRandomFile(this.s);
            return null;
        }
    }
}

