/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.DepthCloneable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.KeyValuePair;

public class Hash
extends Operand {
    public final List<KeyValuePair<Operand, Operand>> pairs;
    public final boolean isKWArgsHash;

    public Hash(List<KeyValuePair<Operand, Operand>> pairs, boolean isKWArgsHash) {
        this.pairs = pairs;
        this.isKWArgsHash = isKWArgsHash;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.HASH;
    }

    public Hash(List<KeyValuePair<Operand, Operand>> pairs) {
        this(pairs, false);
    }

    public boolean isBlank() {
        return this.pairs == null || this.pairs.isEmpty();
    }

    @Override
    public boolean hasKnownValue() {
        for (KeyValuePair<Operand, Operand> pair : this.pairs) {
            if (pair.getKey().hasKnownValue() && pair.getValue().hasKnownValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        ArrayList<KeyValuePair<Operand, Operand>> newPairs = new ArrayList<KeyValuePair<Operand, Operand>>();
        for (KeyValuePair<Operand, Operand> pair : this.pairs) {
            newPairs.add(new KeyValuePair<Operand, Operand>(pair.getKey().getSimplifiedOperand(valueMap, force), pair.getValue().getSimplifiedOperand(valueMap, force)));
        }
        return new Hash(newPairs, this.isKWArgsHash);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (KeyValuePair<Operand, Operand> pair : this.pairs) {
            pair.getKey().addUsedVariables(l);
            pair.getValue().addUsedVariables(l);
        }
    }

    public Operand cloneForLVarDepth(int newDepth) {
        ArrayList<KeyValuePair<Operand, Operand>> newPairs = new ArrayList<KeyValuePair<Operand, Operand>>();
        for (KeyValuePair<Operand, Operand> pair : this.pairs) {
            newPairs.add(new KeyValuePair<Operand, Operand>(pair.getKey(), ((DepthCloneable)((Object)pair.getValue())).cloneForDepth(newDepth)));
        }
        return new Hash(newPairs, this.isKWArgsHash);
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        if (this.hasKnownValue()) {
            return this;
        }
        ArrayList<KeyValuePair<Operand, Operand>> newPairs = new ArrayList<KeyValuePair<Operand, Operand>>();
        for (KeyValuePair<Operand, Operand> pair : this.pairs) {
            newPairs.add(new KeyValuePair<Operand, Operand>(pair.getKey().cloneForInlining(ii), pair.getValue().cloneForInlining(ii)));
        }
        return new Hash(newPairs, this.isKWArgsHash);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        RubyHash hash2;
        Ruby runtime = context.runtime;
        Iterator<KeyValuePair<Operand, Operand>> it = this.pairs.iterator();
        if (this.isKWArgsHash && this.pairs.get(0).getKey() == Symbol.KW_REST_ARG_DUMMY) {
            hash2 = ((RubyHash)this.pairs.get(0).getValue().retrieve(context, self2, currScope, currDynScope, temp)).dupFast(context);
            it.next();
        } else {
            hash2 = RubyHash.newHash(runtime);
        }
        while (it.hasNext()) {
            KeyValuePair<Operand, Operand> pair = it.next();
            IRubyObject key2 = (IRubyObject)pair.getKey().retrieve(context, self2, currScope, currDynScope, temp);
            IRubyObject value2 = (IRubyObject)pair.getValue().retrieve(context, self2, currScope, currDynScope, temp);
            hash2.fastASetCheckString(runtime, key2, value2);
        }
        return hash2;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Hash(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.pairs.size());
        for (KeyValuePair<Operand, Operand> pair : this.pairs) {
            e.encode(pair.getKey());
            e.encode(pair.getValue());
        }
        e.encode(this.isKWArgsHash);
    }

    public static Hash decode(IRReaderDecoder d) {
        int size2 = d.decodeInt();
        ArrayList<KeyValuePair<Operand, Operand>> pairs = new ArrayList<KeyValuePair<Operand, Operand>>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            pairs.add(new KeyValuePair<Operand, Operand>(d.decodeOperand(), d.decodeOperand()));
        }
        return new Hash(pairs, d.decodeBoolean());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (!this.isBlank()) {
            int pairCount = this.pairs.size();
            for (int i2 = 0; i2 < pairCount; ++i2) {
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(this.pairs.get(i2));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public List<KeyValuePair<Operand, Operand>> getPairs() {
        return this.pairs;
    }
}

