/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.ByteArrayOutputStream;
import org.jruby.EvalType;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.InterpretedIRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class MixedModeIRBlockBody
extends IRBlockBody
implements Compilable<CompiledIRBlockBody> {
    private static final Logger LOG = LoggerFactory.getLogger(InterpretedIRBlockBody.class);
    protected boolean pushScope = true;
    protected boolean reuseParentScope = false;
    private boolean displayedCFG = false;
    private volatile int callCount = 0;
    private InterpreterContext interpreterContext;
    private volatile CompiledIRBlockBody jittedBody;

    public MixedModeIRBlockBody(IRClosure closure, Signature signature) {
        super(closure, signature);
        if (!closure.getManager().getInstanceConfig().getCompileMode().shouldJIT() || Options.JIT_THRESHOLD.load() < 0) {
            this.callCount = -1;
        }
    }

    @Override
    public void setEvalType(EvalType evalType) {
        if (this.jittedBody == null) {
            this.evalType.set(evalType);
        } else {
            this.jittedBody.setEvalType(evalType);
        }
    }

    @Override
    public boolean canCallDirect() {
        return this.jittedBody != null || this.interpreterContext != null && this.interpreterContext.hasExplicitCallProtocol();
    }

    @Override
    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    @Override
    public void completeBuild(CompiledIRBlockBody blockBody) {
        this.callCount = -1;
        blockBody.evalType = this.evalType;
        this.jittedBody = blockBody;
    }

    @Override
    public IRScope getIRScope() {
        return this.closure;
    }

    public BlockBody getJittedBody() {
        return this.jittedBody;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.closure.getArgumentDescriptors();
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        if (IRRuntimeHelpers.isDebug() && !this.displayedCFG) {
            LOG.info("Executing '" + this.closure + "' (pushScope=" + this.pushScope + ", reuseParentScope=" + this.reuseParentScope, new Object[0]);
            LOG.info(this.closure.debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
        if (this.interpreterContext == null) {
            if (Options.IR_PRINT.load().booleanValue()) {
                ByteArrayOutputStream baos = IRDumper.printIR(this.closure, false);
                LOG.info("Printing simple IR for " + this.closure.getName(), "\n" + new String(baos.toByteArray()));
            }
            this.interpreterContext = this.closure.getInterpreterContext();
        }
        return this.interpreterContext;
    }

    @Override
    public String getClassName(ThreadContext context) {
        return this.closure.getName();
    }

    @Override
    public String getName() {
        return this.closure.getName();
    }

    @Override
    protected IRubyObject callDirect(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        assert (this.jittedBody != null) : "direct call in MixedModeIRBlockBody without jitted body";
        context.setCurrentBlockType(Block.Type.PROC);
        return this.jittedBody.callDirect(context, block, args2, blockArg);
    }

    @Override
    protected IRubyObject yieldDirect(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        assert (this.jittedBody != null) : "direct yield in MixedModeIRBlockBody without jitted body";
        context.setCurrentBlockType(Block.Type.NORMAL);
        return this.jittedBody.yieldDirect(context, block, args2, self2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject commonYieldPath(ThreadContext context, Block block, Block.Type type2, IRubyObject[] args2, IRubyObject self2, Block blockArg) {
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        InterpreterContext ic = this.ensureInstrsReady();
        Binding binding2 = block.getBinding();
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame prevFrame = context.preYieldNoScope(binding2);
        DynamicScope actualScope = binding2.getDynamicScope();
        if (ic.pushNewDynScope()) {
            context.pushScope(block.allocScope(actualScope));
        } else if (ic.reuseParentDynScope()) {
            context.pushScope(actualScope);
        }
        self2 = IRRuntimeHelpers.updateBlockState(block, self2);
        try {
            IRubyObject iRubyObject = Interpreter.INTERPRET_BLOCK(context, block, self2, ic, args2, binding2.getMethod(), blockArg);
            return iRubyObject;
        }
        finally {
            binding2.getFrame().setVisibility(oldVis);
            if (ic.popDynScope()) {
                context.postYield(binding2, prevFrame);
            } else {
                context.postYieldNoScope(prevFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void promoteToFullBuild(ThreadContext context) {
        if (context.runtime.isBooting() && !Options.JIT_KERNEL.load().booleanValue()) {
            return;
        }
        if (this.callCount >= 0) {
            this.ensureInstrsReady();
            this.closure.prepareForCompilation();
            if (!this.closure.hasExplicitCallProtocol()) {
                if (Options.JIT_LOGGING.load().booleanValue()) {
                    LOG.info("JIT failed; no protocol found in block: " + this.closure, new Object[0]);
                }
                this.callCount = -1;
                return;
            }
            MixedModeIRBlockBody mixedModeIRBlockBody = this;
            synchronized (mixedModeIRBlockBody) {
                if (this.callCount++ >= Options.JIT_THRESHOLD.load()) {
                    this.callCount = -1;
                    context.runtime.getJITCompiler().buildThresholdReached(context, this);
                }
            }
        }
    }

    @Override
    public RubyModule getImplementationClass() {
        return null;
    }
}

