/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.DoubleArrayMirror;
import org.jruby.truffle.core.array.IntegerArrayMirror;
import org.jruby.truffle.core.array.LongArrayMirror;
import org.jruby.truffle.core.array.LongIntArrayMirror;
import org.jruby.truffle.core.array.ObjectArrayMirror;
import org.jruby.truffle.language.RubyGuards;

public abstract class ArrayStrategy {
    public static final ArrayStrategy[] TYPE_STRATEGIES = new ArrayStrategy[]{IntArrayStrategy.INSTANCE, LongArrayStrategy.INSTANCE, DoubleArrayStrategy.INSTANCE, ObjectArrayStrategy.INSTANCE};

    public Class<?> type() {
        throw this.unsupported();
    }

    public boolean canStore(Class<?> type) {
        throw this.unsupported();
    }

    public abstract boolean accepts(Object var1);

    public boolean specializesFor(Object value) {
        throw this.unsupported();
    }

    public abstract boolean matches(DynamicObject var1);

    public abstract ArrayMirror newArray(int var1);

    public abstract ArrayMirror newMirror(DynamicObject var1);

    public abstract String toString();

    public ArrayStrategy generalize(ArrayStrategy other) {
        CompilerAsserts.neverPartOfCompilation();
        if (other == this) {
            return this;
        }
        for (ArrayStrategy generalized : TYPE_STRATEGIES) {
            if (!generalized.canStore(this.type()) || !generalized.canStore(other.type())) continue;
            return generalized;
        }
        throw this.unsupported();
    }

    public ArrayStrategy generalizeFor(Object value) {
        return this.generalize(ArrayStrategy.forValue(value));
    }

    protected RuntimeException unsupported() {
        return new UnsupportedOperationException(this.toString());
    }

    public static ArrayStrategy of(DynamicObject array) {
        CompilerAsserts.neverPartOfCompilation();
        if (!RubyGuards.isRubyArray(array)) {
            return FallbackArrayStrategy.INSTANCE;
        }
        if (ArrayGuards.isIntArray(array)) {
            return IntArrayStrategy.INSTANCE;
        }
        if (ArrayGuards.isLongArray(array)) {
            return LongArrayStrategy.INSTANCE;
        }
        if (ArrayGuards.isDoubleArray(array)) {
            return DoubleArrayStrategy.INSTANCE;
        }
        if (ArrayGuards.isObjectArray(array)) {
            return ObjectArrayStrategy.INSTANCE;
        }
        assert (ArrayGuards.isNullArray(array));
        return FallbackArrayStrategy.INSTANCE;
    }

    public static ArrayStrategy of(DynamicObject array, Object value) {
        CompilerAsserts.neverPartOfCompilation();
        if (ArrayGuards.isLongArray(array) && value instanceof Integer) {
            return LongIntArrayStrategy.INSTANCE;
        }
        return ArrayStrategy.of(array);
    }

    public static ArrayStrategy forValue(Object value) {
        CompilerAsserts.neverPartOfCompilation();
        if (value instanceof Integer) {
            return IntArrayStrategy.INSTANCE;
        }
        if (value instanceof Long) {
            return LongArrayStrategy.INSTANCE;
        }
        if (value instanceof Double) {
            return DoubleArrayStrategy.INSTANCE;
        }
        return ObjectArrayStrategy.INSTANCE;
    }

    private static class FallbackArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new FallbackArrayStrategy();

        private FallbackArrayStrategy() {
        }

        @Override
        public boolean accepts(Object value) {
            return false;
        }

        @Override
        public boolean matches(DynamicObject array) {
            return false;
        }

        @Override
        public ArrayStrategy generalize(ArrayStrategy other) {
            return other;
        }

        @Override
        public ArrayMirror newArray(int size) {
            throw this.unsupported();
        }

        @Override
        public ArrayMirror newMirror(DynamicObject array) {
            throw this.unsupported();
        }

        @Override
        public String toString() {
            return "null";
        }
    }

    private static class IntToObjectGeneralizationArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new IntToObjectGeneralizationArrayStrategy();

        private IntToObjectGeneralizationArrayStrategy() {
        }

        @Override
        public boolean accepts(Object value) {
            return !(value instanceof Long);
        }

        @Override
        public boolean matches(DynamicObject array) {
            return ArrayGuards.isObjectArray(array);
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new ObjectArrayMirror(new Object[size]);
        }

        @Override
        public ArrayMirror newMirror(DynamicObject array) {
            return new ObjectArrayMirror((Object[])Layouts.ARRAY.getStore(array));
        }

        @Override
        public String toString() {
            return "Object[] (not accepting long)";
        }
    }

    private static class LongIntArrayStrategy
    extends LongArrayStrategy {
        static final ArrayStrategy INSTANCE = new LongIntArrayStrategy();

        private LongIntArrayStrategy() {
        }

        @Override
        public boolean accepts(Object value) {
            return value instanceof Integer;
        }

        @Override
        public boolean matches(DynamicObject array) {
            return ArrayGuards.isLongArray(array);
        }

        @Override
        public ArrayMirror newMirror(DynamicObject array) {
            return new LongIntArrayMirror((long[])Layouts.ARRAY.getStore(array));
        }

        @Override
        public String toString() {
            return "(long[], int)";
        }
    }

    private static class ObjectArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new ObjectArrayStrategy();

        private ObjectArrayStrategy() {
        }

        @Override
        public Class<?> type() {
            return Object.class;
        }

        @Override
        public boolean canStore(Class<?> type) {
            return true;
        }

        @Override
        public boolean accepts(Object value) {
            return true;
        }

        @Override
        public boolean specializesFor(Object value) {
            return !(value instanceof Integer) && !(value instanceof Long) && !(value instanceof Double);
        }

        @Override
        public boolean matches(DynamicObject array) {
            return ArrayGuards.isObjectArray(array);
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new ObjectArrayMirror(new Object[size]);
        }

        @Override
        public ArrayMirror newMirror(DynamicObject array) {
            return new ObjectArrayMirror((Object[])Layouts.ARRAY.getStore(array));
        }

        @Override
        public String toString() {
            return "Object[]";
        }
    }

    private static class DoubleArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new DoubleArrayStrategy();

        private DoubleArrayStrategy() {
        }

        @Override
        public Class<?> type() {
            return Double.class;
        }

        @Override
        public boolean canStore(Class<?> type) {
            return type == Double.class;
        }

        @Override
        public boolean accepts(Object value) {
            return value instanceof Double;
        }

        @Override
        public boolean specializesFor(Object value) {
            return value instanceof Double;
        }

        @Override
        public boolean matches(DynamicObject array) {
            return ArrayGuards.isDoubleArray(array);
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new DoubleArrayMirror(new double[size]);
        }

        @Override
        public ArrayMirror newMirror(DynamicObject array) {
            return new DoubleArrayMirror((double[])Layouts.ARRAY.getStore(array));
        }

        @Override
        public String toString() {
            return "double[]";
        }
    }

    private static class LongArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new LongArrayStrategy();

        private LongArrayStrategy() {
        }

        @Override
        public Class<?> type() {
            return Long.class;
        }

        @Override
        public boolean canStore(Class<?> type) {
            return type == Long.class || type == Integer.class;
        }

        @Override
        public boolean accepts(Object value) {
            return value instanceof Long;
        }

        @Override
        public boolean specializesFor(Object value) {
            return value instanceof Long;
        }

        @Override
        public boolean matches(DynamicObject array) {
            return ArrayGuards.isLongArray(array);
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new LongArrayMirror(new long[size]);
        }

        @Override
        public ArrayMirror newMirror(DynamicObject array) {
            return new LongArrayMirror((long[])Layouts.ARRAY.getStore(array));
        }

        @Override
        public String toString() {
            return "long[]";
        }
    }

    private static class IntArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new IntArrayStrategy();

        private IntArrayStrategy() {
        }

        @Override
        public Class<?> type() {
            return Integer.class;
        }

        @Override
        public boolean canStore(Class<?> type) {
            return type == Integer.class;
        }

        @Override
        public boolean accepts(Object value) {
            return value instanceof Integer;
        }

        @Override
        public boolean specializesFor(Object value) {
            return value instanceof Integer;
        }

        @Override
        public boolean matches(DynamicObject array) {
            return ArrayGuards.isIntArray(array);
        }

        @Override
        public ArrayStrategy generalize(ArrayStrategy other) {
            CompilerAsserts.neverPartOfCompilation();
            if (other == this) {
                return this;
            }
            if (other == LongArrayStrategy.INSTANCE) {
                return LongArrayStrategy.INSTANCE;
            }
            return IntToObjectGeneralizationArrayStrategy.INSTANCE;
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new IntegerArrayMirror(new int[size]);
        }

        @Override
        public ArrayMirror newMirror(DynamicObject array) {
            return new IntegerArrayMirror((int[])Layouts.ARRAY.getStore(array));
        }

        @Override
        public String toString() {
            return "int[]";
        }
    }
}

