/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.loader;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.loader.ReentrantLockFreeingMap;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.parser.ParserContext;

public class FeatureLoader {
    private final RubyContext context;
    private final ReentrantLockFreeingMap<String> fileLocks = new ReentrantLockFreeingMap();
    private final Object cextImplementationLock = new Object();
    private boolean cextImplementationLoaded = false;
    private final Object loadedFeaturesLock = new Object();

    public FeatureLoader(RubyContext context) {
        this.context = context;
    }

    public boolean require(VirtualFrame frame, String feature, IndirectCallNode callNode) {
        String featurePath = this.findFeature(feature);
        if (featurePath == null) {
            throw new RaiseException(this.context.getCoreExceptions().loadErrorCannotLoad(feature, callNode));
        }
        return this.doRequire(frame, featurePath, callNode);
    }

    private String findFeature(String feature) {
        String currentDirectory = this.context.getNativePlatform().getPosix().getcwd();
        if (feature.startsWith("./")) {
            feature = currentDirectory + "/" + feature.substring(2);
        } else if (feature.startsWith("../")) {
            feature = currentDirectory.substring(0, currentDirectory.lastIndexOf(47)) + "/" + feature.substring(3);
        }
        if (feature.startsWith("truffle:") || feature.startsWith("jruby:") || new File(feature).isAbsolute()) {
            return this.findFeatureWithAndWithoutExtension(feature);
        }
        for (Object pathObject : ArrayOperations.toIterable(this.context.getCoreLibrary().getLoadPath())) {
            String fileWithinPath = new File(pathObject.toString(), feature).getPath();
            String result = this.findFeatureWithAndWithoutExtension(fileWithinPath);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private String findFeatureWithAndWithoutExtension(String path) {
        String asCExt = this.findFeatureWithExactPath(path + ".su");
        if (asCExt != null) {
            return asCExt;
        }
        String withExtension = this.findFeatureWithExactPath(path + ".rb");
        if (withExtension != null) {
            return withExtension;
        }
        String withoutExtension = this.findFeatureWithExactPath(path);
        if (withoutExtension != null) {
            return withoutExtension;
        }
        return null;
    }

    private String findFeatureWithExactPath(String path) {
        if (path.startsWith("truffle:") || path.startsWith("jruby:")) {
            return path;
        }
        File file = new File(path);
        if (!file.isFile()) {
            return null;
        }
        try {
            if (file.isAbsolute()) {
                return file.getCanonicalPath();
            }
            return new File(this.context.getNativePlatform().getPosix().getcwd(), file.getPath()).getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRequire(VirtualFrame frame, String expandedPath, IndirectCallNode callNode) {
        ReentrantLock lock;
        if (this.isFeatureLoaded(expandedPath)) {
            return false;
        }
        do {
            if (!(lock = this.fileLocks.get(expandedPath)).isHeldByCurrentThread()) continue;
            return false;
        } while (!this.fileLocks.lock(callNode, this.context.getThreadManager(), expandedPath, lock));
        try {
            String mimeType;
            Source source;
            if (this.isFeatureLoaded(expandedPath)) {
                boolean bl = false;
                return bl;
            }
            try {
                source = this.context.getSourceCache().getSource(expandedPath);
            }
            catch (IOException e) {
                boolean bl = false;
                this.fileLocks.unlock(expandedPath, lock);
                return bl;
            }
            switch (mimeType = source.getMimeType()) {
                case "application/x-ruby": {
                    RubyRootNode rootNode = this.context.getCodeLoader().parse(source, (Encoding)UTF8Encoding.INSTANCE, ParserContext.TOP_LEVEL, null, true, callNode);
                    CodeLoader.DeferredCall deferredCall = this.context.getCodeLoader().prepareExecute(ParserContext.TOP_LEVEL, DeclarationContext.TOP_LEVEL, rootNode, null, this.context.getCoreLibrary().getMainObject());
                    deferredCall.call(frame, callNode);
                    break;
                }
                case "application/x-sulong-library": {
                    CallTarget callTarget;
                    this.ensureCExtImplementationLoaded(frame, callNode);
                    try {
                        callTarget = this.context.getEnv().parse(source, new String[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    callNode.call(frame, callTarget, new Object[0]);
                    Object initFunction = this.context.getEnv().importSymbol("@Init_" + this.getBaseName(expandedPath));
                    if (!(initFunction instanceof TruffleObject)) {
                        throw new UnsupportedOperationException();
                    }
                    TruffleObject initFunctionObject = (TruffleObject)initFunction;
                    Node isExecutableNode = Message.IS_EXECUTABLE.createNode();
                    if (!ForeignAccess.sendIsExecutable(isExecutableNode, frame, initFunctionObject)) {
                        throw new UnsupportedOperationException();
                    }
                    Node executeNode = Message.createExecute(0).createNode();
                    try {
                        ForeignAccess.sendExecute(executeNode, frame, initFunctionObject, new Object[0]);
                        break;
                    }
                    catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new RaiseException(this.context.getCoreExceptions().internalError("unknown language " + expandedPath, callNode));
                }
            }
            DynamicObject pathString = StringOperations.createString(this.context, StringOperations.encodeRope(expandedPath, (Encoding)UTF8Encoding.INSTANCE));
            this.addToLoadedFeatures(pathString);
            boolean bl = true;
            return bl;
        }
        finally {
            this.fileLocks.unlock(expandedPath, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCExtImplementationLoaded(VirtualFrame frame, IndirectCallNode callNode) {
        Object object = this.cextImplementationLock;
        synchronized (object) {
            CallTarget callTarget;
            if (this.cextImplementationLoaded) {
                return;
            }
            try {
                callTarget = this.context.getEnv().parse(Source.fromFileName(this.context.getJRubyRuntime().getJRubyHome() + "/lib/ruby/truffle/cext/ruby.su"), new String[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            callNode.call(frame, callTarget, new Object[0]);
            this.cextImplementationLoaded = true;
        }
    }

    private String getBaseName(String path) {
        String name = new File(path).getName();
        int firstDot = name.indexOf(46);
        if (firstDot == -1) {
            return name;
        }
        return name.substring(0, firstDot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFeatureLoaded(String feature) {
        Object object = this.loadedFeaturesLock;
        synchronized (object) {
            DynamicObject loadedFeatures = this.context.getCoreLibrary().getLoadedFeatures();
            for (Object loaded : ArrayOperations.toIterable(loadedFeatures)) {
                if (!loaded.toString().equals(feature)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLoadedFeatures(DynamicObject feature) {
        Object object = this.loadedFeaturesLock;
        synchronized (object) {
            DynamicObject loadedFeatures = this.context.getCoreLibrary().getLoadedFeatures();
            int size = Layouts.ARRAY.getSize(loadedFeatures);
            Object[] store = (Object[])Layouts.ARRAY.getStore(loadedFeatures);
            if (size < store.length) {
                store[size] = feature;
            } else {
                Object[] newStore = ArrayUtils.grow(store, ArrayUtils.capacityForOneMore(this.context, store.length));
                newStore[size] = feature;
                Layouts.ARRAY.setStore(loadedFeatures, newStore);
            }
            Layouts.ARRAY.setSize(loadedFeatures, size + 1);
        }
    }
}

